/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import org.oscim.awt.AwtGraphics;
import org.oscim.backend.DateTime;
import org.oscim.backend.DateTimeAdapter;
import org.oscim.backend.GL;
import org.oscim.backend.GLAdapter;
import org.oscim.core.Tile;
import org.oscim.gdx.GdxAssets;
import org.oscim.gdx.GdxMap;
import org.oscim.gdx.LwjglGL20;
import org.oscim.gdx.LwjglGL30;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.oscimap4.OSciMap4TileSource;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdxMapApp
extends GdxMap {
    public static final Logger log = LoggerFactory.getLogger(GdxMapApp.class);

    public static void init() {
        new SharedLibraryLoader().load("vtm-jni");
        AwtGraphics.init();
        GdxAssets.init((String)"assets/");
        DateTimeAdapter.init((DateTimeAdapter)new DateTime());
    }

    public static void main(String[] args) {
        GdxMapApp.init();
        new LwjglApplication((ApplicationListener)new GdxMapApp(), GdxMapApp.getConfig(null));
    }

    public static void run(GdxMap map) {
        GdxMapApp.run(map, null, Tile.SIZE);
    }

    public static void run(GdxMap map, LwjglApplicationConfiguration config, int tileSize) {
        Tile.SIZE = FastMath.clamp((int)tileSize, (int)128, (int)512);
        new LwjglApplication((ApplicationListener)map, config == null ? GdxMapApp.getConfig(map.getClass().getSimpleName()) : config);
    }

    protected static LwjglApplicationConfiguration getConfig(String title) {
        int[] sizes;
        LwjglApplicationConfiguration.disableAudio = true;
        LwjglApplicationConfiguration cfg = new LwjglApplicationConfiguration();
        cfg.title = title != null ? title : "vtm-gdx";
        for (int size : sizes = new int[]{128, 64, 32, 16}) {
            String path = "res/ic_vtm_" + size + ".png";
            cfg.addIcon(path, Files.FileType.Internal);
        }
        cfg.width = 1024;
        cfg.height = 768;
        cfg.stencil = 8;
        cfg.foregroundFPS = 30;
        cfg.backgroundFPS = 10;
        cfg.forceExit = false;
        return cfg;
    }

    protected void initGLAdapter(GLVersion version) {
        if (version.getMajorVersion() >= 3) {
            GLAdapter.init((GL)new LwjglGL30());
        } else {
            GLAdapter.init((GL)new LwjglGL20());
        }
    }

    public void createLayers() {
        OSciMap4TileSource tileSource = new OSciMap4TileSource();
        this.initDefaultLayers((TileSource)tileSource, false, true, true);
        this.mMap.setMapPosition(0.0, 0.0, 4.0);
    }

    public void dispose() {
        System.exit(0);
    }
}

