/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.awt;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.BufferUtils;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.utils.GraphicUtils;
import org.oscim.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwtBitmap
implements Bitmap {
    private static final Logger log = LoggerFactory.getLogger(AwtBitmap.class);
    BufferedImage bitmap;
    private static final IntBuffer tmpBuffer = BufferUtils.newIntBuffer((int)262144);
    private static final int[] tmpPixel = new int[262144];
    private static final boolean WRITE_TEX = false;
    private int dbgCnt;

    public AwtBitmap(int width, int height, int format) {
        this.bitmap = new BufferedImage(width, height, format != 0 ? format : 2);
    }

    AwtBitmap(InputStream inputStream) throws IOException {
        this.bitmap = ImageIO.read(inputStream);
        if (!this.bitmap.isAlphaPremultiplied() && this.bitmap.getType() == 2) {
            this.bitmap.coerceData(true);
        }
    }

    AwtBitmap(InputStream inputStream, int width, int height, int percent) throws IOException {
        this(inputStream);
        float[] newSize = GraphicUtils.imageSize((float)this.getWidth(), (float)this.getHeight(), (float)CanvasAdapter.getScale(), (int)width, (int)height, (int)percent);
        this.scaleTo((int)newSize[0], (int)newSize[1]);
    }

    public AwtBitmap(BufferedImage bitmap) {
        this.bitmap = bitmap;
        if (!this.bitmap.isAlphaPremultiplied() && this.bitmap.getType() == 2) {
            this.bitmap.coerceData(true);
        }
    }

    public int getWidth() {
        return this.bitmap.getWidth();
    }

    public int getHeight() {
        return this.bitmap.getHeight();
    }

    public int[] getPixels() {
        return null;
    }

    public void eraseColor(int transparent) {
    }

    public void uploadToTexture(boolean replace) {
        IntBuffer buffer;
        int[] pixels;
        if (this.bitmap.getWidth() * this.bitmap.getHeight() < 262144) {
            pixels = tmpPixel;
            buffer = tmpBuffer;
            buffer.clear();
        } else {
            pixels = new int[this.bitmap.getWidth() * this.bitmap.getHeight()];
            buffer = BufferUtils.newIntBuffer((int)(this.bitmap.getWidth() * this.bitmap.getHeight()));
        }
        this.bitmap.getRGB(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight(), pixels, 0, this.bitmap.getWidth());
        int n = this.bitmap.getWidth() * this.bitmap.getHeight();
        for (int i = 0; i < n; ++i) {
            int c = pixels[i];
            if (c == 0) continue;
            float alpha = (float)(c >>> 24) / 255.0f;
            int r = (int)((float)(c & 0xFF) * alpha);
            int b = (int)((float)((c & 0xFF0000) >>> 16) * alpha);
            int g = (int)((float)((c & 0xFF00) >>> 8) * alpha);
            pixels[i] = c & 0xFF000000 | r << 16 | g << 8 | b;
        }
        buffer.put(pixels, 0, this.bitmap.getWidth() * this.bitmap.getHeight());
        buffer.flip();
        Gdx.gl20.glTexImage2D(3553, 0, 6408, this.bitmap.getWidth(), this.bitmap.getHeight(), 0, 6408, 5121, (Buffer)buffer);
    }

    public void recycle() {
    }

    public boolean isValid() {
        return true;
    }

    public byte[] getPngEncodedData() {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.bitmap, "png", outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)outputStream);
        }
        return null;
    }

    public void scaleTo(int width, int height) {
        if (this.getWidth() != width || this.getHeight() != height) {
            BufferedImage resizedImage = new BufferedImage(width, height, 2);
            Graphics2D graphics = resizedImage.createGraphics();
            graphics.setComposite(AlphaComposite.Src);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawImage(this.bitmap, 0, 0, width, height, null);
            graphics.dispose();
            this.bitmap = resizedImage;
        }
    }
}

