/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.awt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import org.oscim.awt.AwtGraphics;
import org.oscim.backend.canvas.Paint;

public class AwtPaint
implements Paint {
    static final Font defaultFont;
    private static final Map<AttributedCharacterIterator.Attribute, Object> textAttributes;
    Color color = new Color(0.1f, 0.1f, 0.1f, 1.0f);
    FontMetrics fm;
    Font font = defaultFont;
    Stroke stroke;
    Paint.Style style = Paint.Style.FILL;
    private int cap = AwtPaint.getCap(Paint.Cap.BUTT);
    private String fontName = defaultFont.getFontName();
    private int fontStyle = defaultFont.getStyle();
    private int join = AwtPaint.getJoin(Paint.Join.MITER);
    private float strokeWidth;
    private float textSize = defaultFont.getSize();
    private final BufferedImage bufferedImage = new BufferedImage(1, 1, 2);

    private static int getCap(Paint.Cap cap) {
        switch (cap) {
            case BUTT: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
            case SQUARE: {
                return 2;
            }
        }
        throw new IllegalArgumentException("unknown cap: " + cap);
    }

    private static String getFontName(Paint.FontFamily fontFamily) {
        switch (fontFamily) {
            case MONOSPACE: {
                return "Monospaced";
            }
            case DEFAULT: 
            case DEFAULT_BOLD: {
                return null;
            }
            case SANS_SERIF: {
                return "SansSerif";
            }
            case SERIF: {
                return "Serif";
            }
        }
        throw new IllegalArgumentException("unknown fontFamily: " + fontFamily);
    }

    private static int getFontStyle(Paint.FontStyle fontStyle) {
        switch (fontStyle) {
            case BOLD: {
                return 1;
            }
            case BOLD_ITALIC: {
                return 3;
            }
            case ITALIC: {
                return 2;
            }
            case NORMAL: {
                return 0;
            }
        }
        throw new IllegalArgumentException("unknown fontStyle: " + fontStyle);
    }

    private static int getJoin(Paint.Join join) {
        switch (join) {
            case ROUND: {
                return 1;
            }
            case BEVEL: {
                return 2;
            }
            case MITER: {
                return 0;
            }
        }
        throw new IllegalArgumentException("unknown cap: " + join);
    }

    public int getColor() {
        return 0;
    }

    public void setColor(int c) {
        this.color = new Color((float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c >> 0 & 0xFF) / 255.0f, (float)(c >> 24 & 0xFF) / 255.0f);
    }

    public void setStrokeCap(Paint.Cap cap) {
        this.cap = AwtPaint.getCap(cap);
        this.createStroke();
    }

    public void setStrokeJoin(Paint.Join join) {
        this.join = AwtPaint.getJoin(join);
        this.createStroke();
    }

    public void setStrokeWidth(float width) {
        this.strokeWidth = width;
        this.createStroke();
    }

    public void setStyle(Paint.Style style) {
        this.style = style;
    }

    public void setTextAlign(Paint.Align align) {
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.font = this.font.deriveFont(textSize);
    }

    public void setTypeface(Paint.FontFamily fontFamily, Paint.FontStyle fontStyle) {
        this.fontName = AwtPaint.getFontName(fontFamily);
        this.fontStyle = AwtPaint.getFontStyle(fontStyle);
        this.font = new Font(this.fontName, this.fontStyle, (int)this.textSize).deriveFont(textAttributes);
    }

    public float measureText(String text) {
        if (this.fm == null) {
            this.fm = AwtGraphics.getFontMetrics(this.font);
        }
        float w = AwtGraphics.getTextWidth(this.fm, text);
        return w + 4.0f;
    }

    public float getFontHeight() {
        if (this.fm == null) {
            this.fm = AwtGraphics.getFontMetrics(this.font);
        }
        float height = this.fm.getHeight();
        return height;
    }

    public float getFontDescent() {
        if (this.fm == null) {
            this.fm = AwtGraphics.getFontMetrics(this.font);
        }
        float desc = this.fm.getDescent();
        return desc;
    }

    private void createStroke() {
        if (this.strokeWidth <= 0.0f) {
            return;
        }
        this.stroke = new BasicStroke(this.strokeWidth, this.cap, this.join, this.join == 0 ? 1.0f : 0.0f, null, 0.0f);
    }

    public float getTextHeight(String text) {
        Graphics2D graphics2d = this.bufferedImage.createGraphics();
        FontMetrics fontMetrics = graphics2d.getFontMetrics(this.font);
        graphics2d.dispose();
        return (float)this.font.createGlyphVector(fontMetrics.getFontRenderContext(), text).getVisualBounds().getHeight();
    }

    public float getTextWidth(String text) {
        Graphics2D graphics2d = this.bufferedImage.createGraphics();
        FontMetrics fontMetrics = graphics2d.getFontMetrics(this.font);
        graphics2d.dispose();
        return fontMetrics.stringWidth(text);
    }

    static {
        textAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        textAttributes.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        defaultFont = new Font("Arial", 0, 14).deriveFont(textAttributes);
    }
}

