/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.backend;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.oscim.backend.AssetAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CanvasAdapter {
    private static final Logger log = LoggerFactory.getLogger(CanvasAdapter.class);
    private static final String PREFIX_ASSETS = "assets:";
    private static final String PREFIX_FILE = "file:";
    static CanvasAdapter g;
    public static float dpi;
    public static float scale;
    public static float textScale;

    protected abstract Canvas newCanvasImpl();

    public static Canvas newCanvas() {
        return g.newCanvasImpl();
    }

    protected abstract Paint newPaintImpl();

    public static Paint newPaint() {
        return g.newPaintImpl();
    }

    protected abstract Bitmap newBitmapImpl(int var1, int var2, int var3);

    public static Bitmap newBitmap(int width, int height, int format) {
        return g.newBitmapImpl(width, height, format);
    }

    protected abstract Bitmap decodeBitmapImpl(InputStream var1);

    public static Bitmap decodeBitmap(InputStream inputStream) {
        return g.decodeBitmapImpl(inputStream);
    }

    protected abstract Bitmap decodeSvgBitmapImpl(InputStream var1);

    public static Bitmap decodeSvgBitmap(InputStream inputStream) {
        return g.decodeSvgBitmapImpl(inputStream);
    }

    protected abstract Bitmap loadBitmapAssetImpl(String var1, String var2);

    public static Bitmap getBitmapAsset(String relativePathPrefix, String src) {
        return g.loadBitmapAssetImpl(relativePathPrefix, src);
    }

    protected static Bitmap createBitmap(String relativePathPrefix, String src) throws IOException {
        InputStream inputStream;
        if (src == null || src.length() == 0) {
            return null;
        }
        if (src.startsWith(PREFIX_ASSETS)) {
            src = src.substring(PREFIX_ASSETS.length());
            inputStream = CanvasAdapter.inputStreamFromAssets(relativePathPrefix, src);
        } else if (src.startsWith(PREFIX_FILE)) {
            src = src.substring(PREFIX_FILE.length());
            inputStream = CanvasAdapter.inputStreamFromFile(relativePathPrefix, src);
        } else {
            inputStream = CanvasAdapter.inputStreamFromFile(relativePathPrefix, src);
            if (inputStream == null) {
                inputStream = CanvasAdapter.inputStreamFromAssets(relativePathPrefix, src);
            }
        }
        if (inputStream == null) {
            log.error("invalid resource: " + src);
            return null;
        }
        Bitmap bitmap = src.toLowerCase(Locale.ENGLISH).endsWith(".svg") ? CanvasAdapter.decodeSvgBitmap(inputStream) : CanvasAdapter.decodeBitmap(inputStream);
        inputStream.close();
        return bitmap;
    }

    private static InputStream inputStreamFromAssets(String relativePathPrefix, String src) throws IOException {
        String pathName = (relativePathPrefix == null || relativePathPrefix.length() == 0 ? "" : relativePathPrefix + File.separatorChar) + src;
        return AssetAdapter.g.openFileAsStream(pathName);
    }

    private static InputStream inputStreamFromFile(String relativePathPrefix, String src) throws IOException {
        File file = CanvasAdapter.getFile(relativePathPrefix, src);
        if (!file.exists()) {
            if (src.length() > 0 && src.charAt(0) == File.separatorChar) {
                file = CanvasAdapter.getFile(relativePathPrefix, src.substring(1));
            }
            if (!file.exists()) {
                file = null;
            }
        } else if (!file.isFile() || !file.canRead()) {
            file = null;
        }
        if (file != null) {
            return new FileInputStream(file);
        }
        return null;
    }

    private static File getFile(String parentPath, String pathName) {
        if (pathName.charAt(0) == File.separatorChar) {
            return new File(pathName);
        }
        return new File(parentPath, pathName);
    }

    protected static void init(CanvasAdapter adapter) {
        g = adapter;
    }

    static {
        dpi = 240.0f;
        scale = 1.0f;
        textScale = 1.0f;
    }
}

