/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.core.BoundingBox;
import org.oscim.core.GeoPoint;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tile;
import org.oscim.utils.FastMath;

public class MapPosition {
    public double x;
    public double y;
    public double scale;
    public float bearing;
    public float tilt;
    public int zoomLevel;

    public MapPosition() {
        this.scale = 1.0;
        this.x = 0.5;
        this.y = 0.5;
        this.zoomLevel = 1;
        this.bearing = 0.0f;
    }

    public MapPosition(double latitude, double longitude, double scale) {
        this.setPosition(latitude, longitude);
        this.setScale(scale);
    }

    public double getX() {
        return this.x;
    }

    public MapPosition setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public MapPosition setY(double y) {
        this.y = y;
        return this;
    }

    public float getBearing() {
        return this.bearing;
    }

    public MapPosition setBearing(float bearing) {
        this.bearing = bearing;
        return this;
    }

    public float getTilt() {
        return this.tilt;
    }

    public MapPosition setTilt(float tilt) {
        this.tilt = tilt;
        return this;
    }

    public double getScale() {
        return this.scale;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public MapPosition setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
        this.scale = 1 << zoomLevel;
        return this;
    }

    public MapPosition setScale(double scale) {
        this.zoomLevel = FastMath.log2((int)scale);
        this.scale = scale;
        return this;
    }

    public void setPosition(GeoPoint geoPoint) {
        this.setPosition(geoPoint.getLatitude(), geoPoint.getLongitude());
    }

    public void setPosition(double latitude, double longitude) {
        latitude = MercatorProjection.limitLatitude(latitude);
        longitude = MercatorProjection.limitLongitude(longitude);
        this.x = MercatorProjection.longitudeToX(longitude);
        this.y = MercatorProjection.latitudeToY(latitude);
    }

    public void copy(MapPosition other) {
        this.x = other.x;
        this.y = other.y;
        this.bearing = other.bearing;
        this.scale = other.scale;
        this.tilt = other.tilt;
        this.zoomLevel = other.zoomLevel;
    }

    public void set(double x, double y, double scale, float bearing, float tilt) {
        this.x = x;
        this.y = y;
        this.scale = scale;
        while (bearing > 180.0f) {
            bearing -= 360.0f;
        }
        while (bearing < -180.0f) {
            bearing += 360.0f;
        }
        this.bearing = bearing;
        this.tilt = tilt;
        this.zoomLevel = FastMath.log2((int)scale);
    }

    public double getZoomScale() {
        return this.scale / (double)(1 << this.zoomLevel);
    }

    public GeoPoint getGeoPoint() {
        return new GeoPoint(MercatorProjection.toLatitude(this.y), MercatorProjection.toLongitude(this.x));
    }

    public double getLatitude() {
        return MercatorProjection.toLatitude(this.y);
    }

    public double getLongitude() {
        return MercatorProjection.toLongitude(this.x);
    }

    public void setByBoundingBox(BoundingBox bbox, int viewWidth, int viewHeight) {
        double minx = MercatorProjection.longitudeToX(bbox.getMinLongitude());
        double miny = MercatorProjection.latitudeToY(bbox.getMaxLatitude());
        double dx = Math.abs(MercatorProjection.longitudeToX(bbox.getMaxLongitude()) - minx);
        double dy = Math.abs(MercatorProjection.latitudeToY(bbox.getMinLatitude()) - miny);
        double zx = (double)viewWidth / (dx * (double)Tile.SIZE);
        double zy = (double)viewHeight / (dy * (double)Tile.SIZE);
        this.scale = Math.min(zx, zy);
        this.zoomLevel = FastMath.log2((int)this.scale);
        this.x = minx + dx / 2.0;
        this.y = miny + dy / 2.0;
        this.bearing = 0.0f;
        this.tilt = 0.0f;
    }

    public String toString() {
        return "[X:" + this.x + ", Y:" + this.y + ", Z:" + this.zoomLevel + "] lat:" + MercatorProjection.toLatitude(this.y) + ", lon:" + MercatorProjection.toLongitude(this.x);
    }
}

