/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.core.GeoPoint;
import org.oscim.core.MapPosition;
import org.oscim.core.Point;
import org.oscim.core.Tile;

public final class MercatorProjection {
    public static final double EARTH_CIRCUMFERENCE = 4.0075016686E7;
    public static final double LATITUDE_MAX = 85.05112877980659;
    public static final double LATITUDE_MIN = -85.05112877980659;
    public static final double LONGITUDE_MAX = 180.0;
    public static final double LONGITUDE_MIN = -180.0;

    public static double groundResolution(double latitude, double scale) {
        return Math.cos(latitude * (Math.PI / 180)) * 4.0075016686E7 / ((double)Tile.SIZE * scale);
    }

    public static float groundResolution(MapPosition pos) {
        double lat = MercatorProjection.toLatitude(pos.y);
        return (float)(Math.cos(lat * (Math.PI / 180)) * 4.0075016686E7 / ((double)Tile.SIZE * pos.scale));
    }

    public static double latitudeToY(double latitude) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        return 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
    }

    public static double toLatitude(double y) {
        return 90.0 - 360.0 * Math.atan(Math.exp((y - 0.5) * (Math.PI * 2))) / Math.PI;
    }

    public static double longitudeToX(double longitude) {
        return (longitude + 180.0) / 360.0;
    }

    public static double toLongitude(double x) {
        return 360.0 * (x - 0.5);
    }

    public static Point project(GeoPoint p, Point reuse) {
        if (reuse == null) {
            reuse = new Point();
        }
        reuse.x = ((double)p.longitudeE6 / 1000000.0 + 180.0) / 360.0;
        double sinLatitude = Math.sin((double)p.latitudeE6 / 1000000.0 * (Math.PI / 180));
        reuse.y = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        return reuse;
    }

    public static void project(GeoPoint p, double[] out, int pos) {
        out[pos * 2] = ((double)p.longitudeE6 / 1000000.0 + 180.0) / 360.0;
        double sinLatitude = Math.sin((double)p.latitudeE6 / 1000000.0 * (Math.PI / 180));
        out[pos * 2 + 1] = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
    }

    public static void project(double latitude, double longitude, double[] out, int pos) {
        out[pos * 2] = (longitude + 180.0) / 360.0;
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        out[pos * 2 + 1] = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
    }

    public static double limitLatitude(double latitude) {
        return Math.max(Math.min(latitude, 85.05112877980659), -85.05112877980659);
    }

    public static double limitLongitude(double longitude) {
        return Math.max(Math.min(longitude, 180.0), -180.0);
    }

    public static double wrapLongitude(double longitude) {
        if (longitude < -180.0) {
            return Math.max(Math.min(360.0 + longitude, 180.0), -180.0);
        }
        if (longitude > 180.0) {
            return Math.max(Math.min(longitude - 360.0, 180.0), -180.0);
        }
        return longitude;
    }

    private MercatorProjection() {
    }
}

