/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.utils.Utils;

public class Tag {
    public static final String KEY_HOUSE_NUMBER = "addr:housenumber";
    public static final String KEY_NAME = "name";
    public static final String KEY_REF = "ref";
    public static final String KEY_ELE = "ele";
    public static final String KEY_AMENITY = "amenity";
    public static final String KEY_BUILDING = "building";
    public static final String KEY_HIGHWAY = "highway";
    public static final String KEY_LANDUSE = "landuse";
    public static final String KEY_HEIGHT = "height";
    public static final String KEY_MIN_HEIGHT = "min_height";
    public static final String VALUE_YES = "yes";
    public static final String VALUE_NO = "no";
    public final String key;
    public String value;
    private final boolean intern;
    private int hashCodeValue = 0;

    public Tag(String key, String value) {
        this.key = key == null ? null : key.intern();
        this.value = value == null ? null : value.intern();
        this.intern = true;
    }

    public Tag(String key, String value, boolean internValue) {
        this.key = key;
        this.value = value == null || !internValue ? value : value.intern();
        this.intern = internValue;
    }

    public Tag(String key, String value, boolean internKey, boolean internValue) {
        this.key = key == null || !internKey ? key : key.intern();
        this.value = value == null || !internValue ? value : value.intern();
        this.intern = internValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)obj;
        if (!Utils.equals(this.key, other.key)) {
            return false;
        }
        return this.intern && other.intern ? Utils.equals(this.value, other.value) : !this.intern && this.value.equals(other.value);
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            this.hashCodeValue = this.calculateHashCode();
        }
        return this.hashCodeValue;
    }

    public String toString() {
        return "Tag[" + this.key + ',' + this.value + ']';
    }

    private int calculateHashCode() {
        int result = 7;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public static Tag parse(String tag) {
        int splitPosition = tag.indexOf(61);
        if (splitPosition < 0) {
            return new Tag(tag, "");
        }
        return new Tag(tag.substring(0, splitPosition), tag.substring(splitPosition + 1));
    }
}

