/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.utils.Timer;
import org.oscim.gdx.InputHandler;
import org.oscim.gdx.LayerHandler;
import org.oscim.gdx.MotionHandler;
import org.oscim.layers.TileGridLayer;
import org.oscim.layers.tile.buildings.BuildingLayer;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.layers.tile.vector.labeling.LabelLayer;
import org.oscim.map.Layers;
import org.oscim.map.Map;
import org.oscim.renderer.MapRenderer;
import org.oscim.theme.VtmThemes;
import org.oscim.tiling.TileSource;

public abstract class GdxMap
implements ApplicationListener {
    protected Map mMap;
    protected GestureDetector mGestureDetector;
    private MapRenderer mMapRenderer;
    boolean mRenderWait;
    boolean mRenderRequest;
    boolean mUpdateRequest;

    protected void initDefaultLayers(TileSource tileSource, boolean tileGrid, boolean labels, boolean buildings) {
        Layers layers = this.mMap.layers();
        if (tileSource != null) {
            VectorTileLayer mapLayer = this.mMap.setBaseMap(tileSource);
            this.mMap.setTheme(VtmThemes.DEFAULT);
            if (buildings) {
                layers.add(new BuildingLayer(this.mMap, mapLayer));
            }
            if (labels) {
                layers.add(new LabelLayer(this.mMap, mapLayer));
            }
        }
        if (tileGrid) {
            layers.add(new TileGridLayer(this.mMap));
        }
    }

    @Override
    public void create() {
        this.mMap = new MapAdapter();
        this.mMapRenderer = new MapRenderer(this.mMap);
        Gdx.graphics.setContinuousRendering(false);
        Gdx.app.setLogLevel(3);
        int w = Gdx.graphics.getWidth();
        int h = Gdx.graphics.getHeight();
        this.mMap.viewport().setScreenSize(w, h);
        this.mMapRenderer.onSurfaceCreated();
        this.mMapRenderer.onSurfaceChanged(w, h);
        InputMultiplexer mux = new InputMultiplexer();
        this.mGestureDetector = new GestureDetector(new LayerHandler(this.mMap));
        mux.addProcessor(this.mGestureDetector);
        mux.addProcessor(new InputHandler(this));
        mux.addProcessor(new MotionHandler(this.mMap));
        Gdx.input.setInputProcessor(mux);
        this.createLayers();
    }

    protected void createLayers() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void render() {
        if (!this.mRenderRequest) {
            return;
        }
        this.mMapRenderer.onDrawFrame();
    }

    @Override
    public void resize(int w, int h) {
        this.mMap.viewport().setScreenSize(w, h);
        this.mMapRenderer.onSurfaceChanged(w, h);
        this.mMap.render();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    protected boolean onKeyDown(int keycode) {
        return false;
    }

    public Map getMap() {
        return this.mMap;
    }

    class MapAdapter
    extends Map {
        private final Runnable mRedrawCb = new Runnable(){

            @Override
            public void run() {
                MapAdapter.this.prepareFrame();
                Gdx.graphics.requestRendering();
            }
        };

        MapAdapter() {
        }

        @Override
        public int getWidth() {
            return Gdx.graphics.getWidth();
        }

        @Override
        public int getHeight() {
            return Gdx.graphics.getHeight();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateMap(boolean forceRender) {
            Runnable runnable = this.mRedrawCb;
            synchronized (runnable) {
                if (!GdxMap.this.mRenderRequest) {
                    GdxMap.this.mRenderRequest = true;
                    Gdx.app.postRunnable(this.mRedrawCb);
                } else {
                    GdxMap.this.mRenderWait = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void render() {
            Runnable runnable = this.mRedrawCb;
            synchronized (runnable) {
                GdxMap.this.mRenderRequest = true;
                if (this.mClearMap) {
                    this.updateMap(false);
                } else {
                    Gdx.graphics.requestRendering();
                }
            }
        }

        @Override
        public boolean post(Runnable runnable) {
            Gdx.app.postRunnable(runnable);
            return true;
        }

        @Override
        public boolean postDelayed(final Runnable action, long delay) {
            Timer.schedule(new Timer.Task(){

                @Override
                public void run() {
                    action.run();
                }
            }, (float)delay / 1000.0f);
            return true;
        }

        @Override
        public void beginFrame() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doneFrame(boolean animate) {
            Runnable runnable = this.mRedrawCb;
            synchronized (runnable) {
                GdxMap.this.mRenderRequest = false;
                if (animate || GdxMap.this.mRenderWait) {
                    GdxMap.this.mRenderWait = false;
                    this.updateMap(true);
                }
            }
        }
    }
}

