/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import org.oscim.awt.AwtGraphics;
import org.oscim.backend.GLAdapter;
import org.oscim.core.Tile;
import org.oscim.gdx.GdxAssets;
import org.oscim.gdx.GdxMap;
import org.oscim.gdx.LwjglGL20;
import org.oscim.tiling.source.oscimap4.OSciMap4TileSource;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdxMapApp
extends GdxMap {
    public static final Logger log = LoggerFactory.getLogger(GdxMapApp.class);

    public static void init() {
        new SharedLibraryLoader().load("vtm-jni");
        AwtGraphics.init();
        GdxAssets.init("assets/");
        GLAdapter.init(new LwjglGL20());
        GLAdapter.GDX_DESKTOP_QUIRKS = true;
    }

    public static void main(String[] args) {
        GdxMapApp.init();
        new LwjglApplication((ApplicationListener)new GdxMapApp(), GdxMapApp.getConfig());
    }

    public static void run(GdxMap map) {
        GdxMapApp.run(map, null, Tile.SIZE);
    }

    public static void run(GdxMap map, LwjglApplicationConfiguration config, int tileSize) {
        Tile.SIZE = FastMath.clamp(tileSize, 128, 512);
        new LwjglApplication((ApplicationListener)map, config == null ? GdxMapApp.getConfig() : config);
    }

    protected static LwjglApplicationConfiguration getConfig() {
        LwjglApplicationConfiguration.disableAudio = true;
        LwjglApplicationConfiguration cfg = new LwjglApplicationConfiguration();
        cfg.title = "vtm-gdx";
        cfg.width = 800;
        cfg.height = 600;
        cfg.stencil = 8;
        cfg.samples = 2;
        cfg.foregroundFPS = 30;
        cfg.backgroundFPS = 10;
        return cfg;
    }

    @Override
    public void createLayers() {
        OSciMap4TileSource tileSource = new OSciMap4TileSource();
        this.initDefaultLayers(tileSource, false, true, true);
        this.mMap.setMapPosition(0.0, 0.0, 4.0);
    }
}

