/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import org.oscim.gdx.GdxMap;
import org.oscim.layers.GenericLayer;
import org.oscim.layers.TileGridLayer;
import org.oscim.map.Map;
import org.oscim.map.ViewController;
import org.oscim.theme.VtmThemes;

public class InputHandler
implements InputProcessor {
    private ViewController mViewport;
    private final Map mMap;
    private GenericLayer mGridLayer;
    private final GdxMap mGdxApp;
    private boolean mActiveScale;
    private boolean mActiveTilt;
    private boolean mActiveRotate;
    private int mPosX;
    private int mPosY;

    public InputHandler(GdxMap map) {
        this.mMap = map.getMap();
        this.mViewport = this.mMap.viewport();
        this.mGdxApp = map;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (this.mGdxApp.onKeyDown(keycode)) {
            return true;
        }
        switch (keycode) {
            case 131: {
                Gdx.app.exit();
                break;
            }
            case 59: 
            case 60: {
                this.mActiveScale = true;
                this.mPosY = Gdx.input.getY();
                break;
            }
            case 129: 
            case 130: {
                this.mActiveRotate = true;
                this.mActiveTilt = true;
                this.mPosX = Gdx.input.getX();
                this.mPosY = Gdx.input.getY();
                break;
            }
            case 19: {
                this.mViewport.moveMap(0.0f, -50.0f);
                this.mMap.updateMap(true);
                break;
            }
            case 20: {
                this.mViewport.moveMap(0.0f, 50.0f);
                this.mMap.updateMap(true);
                break;
            }
            case 21: {
                this.mViewport.moveMap(-50.0f, 0.0f);
                this.mMap.updateMap(true);
                break;
            }
            case 22: {
                this.mViewport.moveMap(50.0f, 0.0f);
                this.mMap.updateMap(true);
                break;
            }
            case 41: {
                this.mViewport.scaleMap(1.05f, 0.0f, 0.0f);
                this.mMap.updateMap(true);
                break;
            }
            case 42: {
                this.mViewport.scaleMap(0.95f, 0.0f, 0.0f);
                this.mMap.updateMap(true);
                break;
            }
            case 8: {
                this.mMap.animator().animateZoom(500L, 0.5, 0.0f, 0.0f);
                this.mMap.updateMap(false);
                break;
            }
            case 9: {
                this.mMap.animator().animateZoom(500L, 2.0, 0.0f, 0.0f);
                this.mMap.updateMap(false);
                break;
            }
            case 32: {
                this.mMap.setTheme(VtmThemes.DEFAULT);
                this.mMap.updateMap(false);
                break;
            }
            case 48: {
                this.mMap.setTheme(VtmThemes.TRONRENDER);
                this.mMap.updateMap(false);
                break;
            }
            case 46: {
                this.mMap.setTheme(VtmThemes.OSMARENDER);
                this.mMap.updateMap(false);
                break;
            }
            case 35: {
                if (this.mGridLayer == null) {
                    this.mGridLayer = new TileGridLayer(this.mMap);
                    this.mGridLayer.setEnabled(true);
                    this.mMap.layers().add(this.mGridLayer);
                } else if (this.mGridLayer.isEnabled()) {
                    this.mGridLayer.setEnabled(false);
                    this.mMap.layers().remove(this.mGridLayer);
                } else {
                    this.mGridLayer.setEnabled(true);
                    this.mMap.layers().add(this.mGridLayer);
                }
                this.mMap.render();
            }
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        switch (keycode) {
            case 59: 
            case 60: {
                this.mActiveScale = false;
                break;
            }
            case 129: 
            case 130: {
                this.mActiveRotate = false;
                this.mActiveTilt = false;
            }
        }
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (button == 2) {
            this.mActiveScale = true;
            this.mPosY = screenY;
        } else if (button == 1) {
            this.mActiveRotate = true;
            this.mPosX = screenX;
            this.mPosY = screenY;
            return true;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.mActiveScale = false;
        this.mActiveRotate = false;
        this.mActiveTilt = false;
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        boolean changed = false;
        if (!(this.mActiveScale || this.mActiveRotate || this.mActiveTilt)) {
            return false;
        }
        if (this.mActiveTilt) {
            changed = this.mViewport.tiltMap((float)(screenY - this.mPosY) / 5.0f);
            this.mPosY = screenY;
        }
        if (this.mActiveScale) {
            changed = this.mViewport.scaleMap(1.0f - (float)(screenY - this.mPosY) / 100.0f, 0.0f, 0.0f);
            this.mPosY = screenY;
        }
        if (this.mActiveRotate) {
            this.mViewport.rotateMap((float)(screenX - this.mPosX) / 500.0f, 0.0f, 0.0f);
            this.mPosX = screenX;
            this.mViewport.tiltMap((float)(screenY - this.mPosY) / 10.0f);
            this.mPosY = screenY;
            changed = true;
        }
        if (changed) {
            this.mMap.updateMap(true);
        }
        return true;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        this.mPosX = screenX;
        this.mPosY = screenY;
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        float fx = this.mPosX - this.mMap.getWidth() / 2;
        float fy = this.mPosY - this.mMap.getHeight() / 2;
        this.mMap.animator().animateZoom(250L, amount > 0 ? 0.75 : (double)1.333f, fx, fy);
        this.mMap.updateMap(false);
        return true;
    }
}

