/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker;

import java.util.Comparator;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.layers.marker.MarkerInterface;
import org.oscim.layers.marker.MarkerLayer;
import org.oscim.layers.marker.MarkerSymbol;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.SymbolBucket;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.utils.TimSort;
import org.oscim.utils.geom.GeometryUtils;

public class MarkerRenderer
extends BucketRenderer {
    protected final MarkerSymbol mDefaultMarker;
    private final SymbolBucket mSymbolLayer;
    private final float[] mBox = new float[8];
    private final MarkerLayer<MarkerInterface> mMarkerLayer;
    private final Point mMapPoint = new Point();
    protected int mExtents = 100;
    private boolean mUpdate;
    private InternalItem[] mItems;
    static TimSort<InternalItem> ZSORT = new TimSort();
    static final Comparator<InternalItem> zComparator = new Comparator<InternalItem>(){

        @Override
        public int compare(InternalItem a, InternalItem b) {
            if (a.visible && b.visible) {
                if (a.dy > b.dy) {
                    return -1;
                }
                if (a.dy < b.dy) {
                    return 1;
                }
            } else {
                if (a.visible) {
                    return -1;
                }
                if (b.visible) {
                    return 1;
                }
            }
            return 0;
        }
    };

    public MarkerRenderer(MarkerLayer<MarkerInterface> markerLayer, MarkerSymbol defaultSymbol) {
        this.mSymbolLayer = new SymbolBucket();
        this.mMarkerLayer = markerLayer;
        this.mDefaultMarker = defaultSymbol;
    }

    @Override
    public synchronized void update(GLViewport v) {
        if (!v.changed() && !this.mUpdate) {
            return;
        }
        this.mUpdate = false;
        double mx = v.pos.x;
        double my = v.pos.y;
        double scale = (double)Tile.SIZE * v.pos.scale;
        int numVisible = 0;
        this.mMarkerLayer.map().viewport().getMapExtents(this.mBox, this.mExtents);
        long flip = (long)((double)Tile.SIZE * v.pos.scale) >> 1;
        if (this.mItems == null) {
            if (this.buckets.get() != null) {
                this.buckets.clear();
                this.compile();
            }
            return;
        }
        double angle = Math.toRadians(v.pos.bearing);
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        for (InternalItem it : this.mItems) {
            it.changes = false;
            it.x = (float)((it.px - mx) * scale);
            it.y = (float)((it.py - my) * scale);
            if (it.x > (float)flip) {
                it.x -= (float)(flip << 1);
            } else if (it.x < (float)(-flip)) {
                it.x += (float)(flip << 1);
            }
            if (!GeometryUtils.pointInPoly(it.x, it.y, this.mBox, 8, 0)) {
                if (!it.visible) continue;
                it.changes = true;
                continue;
            }
            it.dy = sin * it.x + cos * it.y;
            if (!it.visible) {
                it.visible = true;
            }
            ++numVisible;
        }
        this.buckets.clear();
        if (numVisible == 0) {
            this.compile();
            return;
        }
        this.mMapPosition.copy(v.pos);
        this.mMapPosition.bearing = -this.mMapPosition.bearing;
        MarkerRenderer.sort(this.mItems, 0, this.mItems.length);
        for (InternalItem it : this.mItems) {
            if (!it.visible) continue;
            if (it.changes) {
                it.visible = false;
                continue;
            }
            MarkerSymbol marker = it.item.getMarker();
            if (marker == null) {
                marker = this.mDefaultMarker;
            }
            SymbolItem s = SymbolItem.pool.get();
            s.set(it.x, it.y, marker.getBitmap(), true);
            s.offset = marker.getHotspot();
            s.billboard = marker.isBillboard();
            this.mSymbolLayer.pushSymbol(s);
        }
        this.buckets.set(this.mSymbolLayer);
        this.buckets.prepare();
        this.compile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populate(int size) {
        InternalItem[] tmp = new InternalItem[size];
        for (int i = 0; i < size; ++i) {
            InternalItem it;
            tmp[i] = it = new InternalItem();
            it.item = this.mMarkerLayer.createItem(i);
            MercatorProjection.project(it.item.getPoint(), this.mMapPoint);
            it.px = this.mMapPoint.x;
            it.py = this.mMapPoint.y;
        }
        MarkerRenderer markerRenderer = this;
        synchronized (markerRenderer) {
            this.mUpdate = true;
            this.mItems = tmp;
        }
    }

    public void update() {
        this.mUpdate = true;
    }

    public static void sort(InternalItem[] a, int lo, int hi) {
        int nRemaining = hi - lo;
        if (nRemaining < 2) {
            return;
        }
        ZSORT.doSort((InternalItem[])a, zComparator, lo, hi);
    }

    static class InternalItem {
        MarkerInterface item;
        boolean visible;
        boolean changes;
        float x;
        float y;
        double px;
        double py;
        float dy;

        InternalItem() {
        }

        public String toString() {
            return "\n" + this.x + ":" + this.y + " / " + this.dy + " " + this.visible;
        }
    }
}

