/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.PointF;

public class MarkerSymbol {
    final Bitmap mBitmap;
    final PointF mOffset;
    final boolean mBillboard;

    public MarkerSymbol(Bitmap bitmap, float relX, float relY) {
        this(bitmap, relX, relY, true);
    }

    public MarkerSymbol(Bitmap bitmap, float relX, float relY, boolean billboard) {
        this.mBitmap = bitmap;
        this.mOffset = new PointF(relX, relY);
        this.mBillboard = billboard;
    }

    public MarkerSymbol(Bitmap bitmap, HotspotPlace hotspot) {
        this(bitmap, hotspot, true);
    }

    public MarkerSymbol(Bitmap bitmap, HotspotPlace hotspot, boolean billboard) {
        switch (hotspot) {
            case BOTTOM_CENTER: {
                this.mOffset = new PointF(0.5f, 1.0f);
                break;
            }
            case TOP_CENTER: {
                this.mOffset = new PointF(0.5f, 0.0f);
                break;
            }
            case RIGHT_CENTER: {
                this.mOffset = new PointF(1.0f, 0.5f);
                break;
            }
            case LEFT_CENTER: {
                this.mOffset = new PointF(0.0f, 0.5f);
                break;
            }
            case UPPER_RIGHT_CORNER: {
                this.mOffset = new PointF(1.0f, 0.0f);
                break;
            }
            case LOWER_RIGHT_CORNER: {
                this.mOffset = new PointF(1.0f, 1.0f);
                break;
            }
            case UPPER_LEFT_CORNER: {
                this.mOffset = new PointF(0.0f, 0.0f);
                break;
            }
            case LOWER_LEFT_CORNER: {
                this.mOffset = new PointF(0.0f, 1.0f);
                break;
            }
            default: {
                this.mOffset = new PointF(0.5f, 0.5f);
            }
        }
        this.mBitmap = bitmap;
        this.mBillboard = billboard;
    }

    public boolean isBillboard() {
        return this.mBillboard;
    }

    public PointF getHotspot() {
        return this.mOffset;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public boolean isInside(float dx, float dy) {
        int w = this.mBitmap.getWidth();
        int h = this.mBitmap.getHeight();
        float ox = (float)(-w) * this.mOffset.x;
        float oy = (float)(-h) * (1.0f - this.mOffset.y);
        return dx >= ox && dy >= oy && dx <= ox + (float)w && dy <= oy + (float)h;
    }

    public static enum HotspotPlace {
        NONE,
        CENTER,
        BOTTOM_CENTER,
        TOP_CENTER,
        RIGHT_CENTER,
        LEFT_CENTER,
        UPPER_RIGHT_CORNER,
        LOWER_RIGHT_CORNER,
        UPPER_LEFT_CORNER,
        LOWER_LEFT_CORNER;

    }
}

