/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.layers.Layer;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.layers.tile.vector.labeling.LabelPlacement;
import org.oscim.layers.tile.vector.labeling.LabelTask;
import org.oscim.layers.tile.vector.labeling.LabelTileLoaderHook;
import org.oscim.layers.tile.vector.labeling.TextRenderer;
import org.oscim.map.Map;
import org.oscim.utils.async.SimpleWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelLayer
extends Layer
implements Map.UpdateListener,
TileManager.Listener {
    static final Logger log = LoggerFactory.getLogger(LabelLayer.class);
    public static final String LABEL_DATA = LabelLayer.class.getName();
    private static final long MAX_RELABEL_DELAY = 100L;
    private final LabelPlacement mLabelPlacer;
    private final Worker mWorker;

    public LabelLayer(Map map, VectorTileLayer l) {
        super(map);
        l.getManager().events.bind(this);
        l.addHook(new LabelTileLoaderHook());
        this.mLabelPlacer = new LabelPlacement(map, l.tileRenderer());
        this.mWorker = new Worker(map);
        this.mRenderer = new TextRenderer(this.mWorker);
    }

    public void clearLabels() {
        this.mWorker.cancel(true);
    }

    public void update() {
        this.mWorker.submit(100L);
    }

    @Override
    public void onDetach() {
        this.mWorker.cancel(true);
        super.onDetach();
    }

    @Override
    public void onMapEvent(Event event, MapPosition mapPosition) {
        if (event == Map.CLEAR_EVENT) {
            this.mWorker.cancel(true);
        }
        if (event == Map.POSITION_EVENT) {
            this.mWorker.submit(100L);
        }
    }

    @Override
    public void onTileManagerEvent(Event e, MapTile tile) {
        if (e == TileManager.TILE_LOADED) {
            if (tile.isVisible) {
                this.mWorker.submit(25L);
            }
        } else if (e == TileManager.TILE_REMOVED) {
            // empty if block
        }
    }

    class Worker
    extends SimpleWorker<LabelTask> {
        public Worker(Map map) {
            super(map, 50L, new LabelTask(), new LabelTask());
        }

        @Override
        public boolean doWork(LabelTask t) {
            if (LabelLayer.this.mLabelPlacer.updateLabels(t)) {
                this.mMap.render();
                return true;
            }
            return false;
        }

        @Override
        public void cleanup(LabelTask t) {
        }

        @Override
        public void finish() {
            LabelLayer.this.mLabelPlacer.cleanup();
        }

        @Override
        public synchronized boolean isRunning() {
            return this.mRunning;
        }
    }
}

