/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.PointF;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.layers.tile.vector.labeling.LabelLayer;
import org.oscim.layers.tile.vector.labeling.LabelTileData;
import org.oscim.layers.tile.vector.labeling.WayDecorator;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;

public class LabelTileLoaderHook
implements VectorTileLayer.TileLoaderThemeHook {
    private LabelTileData get(MapTile tile) {
        LabelTileData ld = (LabelTileData)tile.getData(LabelLayer.LABEL_DATA);
        if (ld == null) {
            ld = new LabelTileData();
            tile.addData(LabelLayer.LABEL_DATA, ld);
        }
        return ld;
    }

    @Override
    public boolean process(MapTile tile, RenderBuckets buckets, MapElement element, RenderStyle style, int level) {
        block13: {
            block11: {
                TextStyle text;
                LabelTileData ld;
                block14: {
                    block12: {
                        if (!(style instanceof TextStyle)) break block11;
                        ld = this.get(tile);
                        text = (TextStyle)style;
                        if (element.type != GeometryBuffer.GeometryType.LINE) break block12;
                        String value = element.tags.getValue(text.textKey);
                        if (value == null || value.length() == 0) {
                            return false;
                        }
                        int offset = 0;
                        for (int length : element.index) {
                            if (length < 4) break;
                            WayDecorator.renderText(null, element.points, value, text, offset, length, ld);
                            offset += length;
                        }
                        break block13;
                    }
                    if (element.type != GeometryBuffer.GeometryType.POLY) break block14;
                    String value = element.tags.getValue(text.textKey);
                    if (value == null || value.length() == 0) {
                        return false;
                    }
                    float x = 0.0f;
                    float y = 0.0f;
                    int n = element.index[0];
                    int i = 0;
                    while (i < n) {
                        x += element.points[i++];
                        y += element.points[i++];
                    }
                    ld.labels.push(TextItem.pool.get().set(x /= (float)(n / 2), y /= (float)(n / 2), value, text));
                    break block13;
                }
                if (element.type != GeometryBuffer.GeometryType.POINT) break block13;
                String value = element.tags.getValue(text.textKey);
                if (value == null || value.length() == 0) {
                    return false;
                }
                int n = element.getNumPoints();
                for (int i = 0; i < n; ++i) {
                    PointF p = element.getPoint(i);
                    ld.labels.push(TextItem.pool.get().set(p.x, p.y, value, text));
                }
                break block13;
            }
            if (element.type == GeometryBuffer.GeometryType.POINT && style instanceof SymbolStyle) {
                SymbolStyle symbol = (SymbolStyle)style;
                if (symbol.bitmap == null && symbol.texture == null) {
                    return false;
                }
                LabelTileData ld = this.get(tile);
                int n = element.getNumPoints();
                for (int i = 0; i < n; ++i) {
                    PointF p = element.getPoint(i);
                    SymbolItem it = SymbolItem.pool.get();
                    if (symbol.bitmap != null) {
                        it.set(p.x, p.y, symbol.bitmap, true);
                    } else {
                        it.set(p.x, p.y, symbol.texture, true);
                    }
                    ld.symbols.push(it);
                }
            }
        }
        return false;
    }

    @Override
    public void complete(MapTile tile, boolean success) {
    }
}

