/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.map.Map;
import org.oscim.renderer.BufferObject;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.NativeBufferPool;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.TextureItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRenderer {
    static final Logger log = LoggerFactory.getLogger(MapRenderer.class);
    public static final float COORD_SCALE = 8.0f;
    private final Map mMap;
    private final GLViewport mViewport;
    private static float[] mClearColor;
    private static int mQuadIndicesID;
    private static int mQuadVerticesID;
    public static final int MAX_QUADS = 512;
    public static final int MAX_INDICES = 3072;
    public static long frametime;
    private static boolean rerender;
    private static NativeBufferPool mBufferPool;
    private float viewPortScale = 1.0f;
    private boolean mNewSurface;

    public MapRenderer(Map map) {
        this.mMap = map;
        this.mViewport = new GLViewport();
        mBufferPool = new NativeBufferPool();
        BufferObject.clear();
        MapRenderer.setBackgroundColor(-12303292);
    }

    public static void setBackgroundColor(int color) {
        mClearColor = GLUtils.colorToFloat(color);
    }

    public void setViewPortScale(float scale) {
        this.viewPortScale = scale;
    }

    public void onDrawFrame() {
        frametime = System.currentTimeMillis();
        rerender = false;
        this.mMap.beginFrame();
        this.draw();
        this.mMap.doneFrame(rerender);
        mBufferPool.releaseBuffers();
        TextureItem.disposeTextures();
    }

    private void draw() {
        GLState.setClearColor(mClearColor);
        GLAdapter.gl.depthMask(true);
        GLAdapter.gl.stencilMask(255);
        GLAdapter.gl.clear(17664);
        GLAdapter.gl.depthMask(false);
        GLAdapter.gl.stencilMask(0);
        GLState.test(false, false);
        GLState.blend(false);
        GLState.bindTex2D(-1);
        GLState.useProgram(-1);
        GLState.bindElementBuffer(-1);
        GLState.bindVertexBuffer(-1);
        this.mViewport.setFrom(this.mMap);
        if (this.viewPortScale != 1.0f) {
            this.mViewport.mvp.setScale(this.viewPortScale, this.viewPortScale, 1.0f);
            this.mViewport.viewproj.multiplyLhs(this.mViewport.mvp);
            this.mViewport.proj.multiplyLhs(this.mViewport.mvp);
        }
        for (LayerRenderer renderer : this.mMap.layers().getLayerRenderer()) {
            if (!renderer.isInitialized) {
                renderer.setup();
                renderer.isInitialized = true;
            }
            renderer.update(this.mViewport);
            if (!renderer.isReady) continue;
            renderer.render(this.mViewport);
        }
        if (GLUtils.checkGlOutOfMemory("finish")) {
            BufferObject.checkBufferUsage(true);
        }
    }

    public void onSurfaceChanged(int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        GLAdapter.gl.viewport(0, 0, width, height);
        GLAdapter.gl.clearStencil(0);
        GLAdapter.gl.disable(2884);
        GLAdapter.gl.blendFunc(1, 771);
        GLAdapter.gl.frontFace(2304);
        GLAdapter.gl.cullFace(1029);
        if (!this.mNewSurface) {
            this.mMap.updateMap(false);
            return;
        }
        this.mNewSurface = false;
        int[] vboIds = GLUtils.glGenBuffers(2);
        mQuadIndicesID = vboIds[0];
        short[] indices = new short[3072];
        int i = 0;
        int j = 0;
        while (i < 3072) {
            indices[i + 0] = (short)(j + 0);
            indices[i + 1] = (short)(j + 1);
            indices[i + 2] = (short)(j + 2);
            indices[i + 3] = (short)(j + 2);
            indices[i + 4] = (short)(j + 1);
            indices[i + 5] = (short)(j + 3);
            i += 6;
            j += 4;
        }
        ShortBuffer buf = MapRenderer.getShortBuffer(indices.length);
        buf.put(indices);
        buf.flip();
        GLState.bindElementBuffer(mQuadIndicesID);
        GLAdapter.gl.bufferData(34963, indices.length * 2, buf, 35044);
        GLState.bindElementBuffer(0);
        FloatBuffer floatBuffer = MapRenderer.getFloatBuffer(8);
        float[] quad = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
        floatBuffer.put(quad);
        floatBuffer.flip();
        mQuadVerticesID = vboIds[1];
        GLState.bindVertexBuffer(mQuadVerticesID);
        GLAdapter.gl.bufferData(34962, quad.length * 4, floatBuffer, 35044);
        GLState.bindVertexBuffer(0);
        GLState.init();
        this.mMap.updateMap(true);
    }

    public void onSurfaceCreated() {
        String vendor = GLAdapter.gl.getString(7936);
        String renderer = GLAdapter.gl.getString(7937);
        String version = GLAdapter.gl.getString(7938);
        log.debug("{}/{}/{}", vendor, renderer, version);
        if (renderer != null && renderer.startsWith("Adreno (TM) 3")) {
            log.debug("==> not using glBufferSubData");
            GLAdapter.NO_BUFFER_SUB_DATA = true;
        }
        GLState.init();
        BufferObject.init(200);
        RenderBuckets.initRenderer();
        this.mNewSurface = true;
    }

    public static void bindQuadVertexVBO(int location) {
        if (location >= 0) {
            GLState.bindVertexBuffer(mQuadVerticesID);
            GLState.enableVertexArrays(location, -1);
            GLAdapter.gl.vertexAttribPointer(location, 2, 5126, false, 0, 0);
        }
    }

    public static void bindQuadIndicesVBO() {
        GLState.bindElementBuffer(mQuadIndicesID);
    }

    public static void animate() {
        rerender = true;
    }

    public static FloatBuffer getFloatBuffer(int size) {
        return mBufferPool.getFloatBuffer(size);
    }

    public static ShortBuffer getShortBuffer(int size) {
        return mBufferPool.getShortBuffer(size);
    }

    public static IntBuffer getIntBuffer(int size) {
        return mBufferPool.getIntBuffer(size);
    }
}

