/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.atlas;

import java.util.HashMap;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.utils.pool.Inlist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextureAtlas
extends Inlist<TextureAtlas> {
    static final Logger log = LoggerFactory.getLogger(TextureAtlas.class);
    public Slot mSlots;
    private Rect mRects;
    final int mWidth;
    final int mHeight;
    int mUsed;
    public TextureItem texture;
    private HashMap<Object, TextureRegion> mRegions;

    public TextureAtlas(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mSlots = new Slot(1, 1, width - 2);
    }

    public TextureAtlas(Bitmap bitmap) {
        this.texture = new TextureItem(bitmap);
        this.mWidth = this.texture.width;
        this.mHeight = this.texture.height;
        this.mRegions = new HashMap();
    }

    public void addTextureRegion(Object key, Rect r) {
        this.mRegions.put(key, new TextureRegion(this.texture, r));
    }

    public TextureRegion getTextureRegion(Object key) {
        return this.mRegions.get(key);
    }

    public Rect getRegion(int width, int height) {
        Rect r = new Rect(0, 0, width, height);
        int bestHeight = Integer.MAX_VALUE;
        int bestWidth = Integer.MAX_VALUE;
        Slot bestSlot = null;
        Slot slot = this.mSlots;
        while (slot != null) {
            if (slot.x + width <= this.mWidth - 1) {
                int h;
                int y = slot.y;
                Slot fit = slot;
                for (int widthLeft = width; widthLeft > 0; widthLeft -= fit.w) {
                    if (fit.y > y) {
                        y = fit.y;
                    }
                    if (y + height > this.mHeight - 1) {
                        y = -1;
                        break;
                    }
                    fit = (Slot)fit.next;
                }
                if (y >= 0 && ((h = y + height) < bestHeight || h == bestHeight && slot.w < bestWidth)) {
                    bestHeight = h;
                    bestSlot = slot;
                    bestWidth = slot.w;
                    r.x = slot.x;
                    r.y = y;
                }
            }
            slot = (Slot)slot.next;
        }
        if (bestSlot == null) {
            return null;
        }
        Slot curSlot = new Slot(r.x, r.y + height, width);
        this.mSlots = Inlist.prependRelative(this.mSlots, curSlot, bestSlot);
        Slot prev = curSlot;
        while (prev.next != null) {
            slot = (Slot)prev.next;
            int shrink = prev.x + prev.w - slot.x;
            if (shrink <= 0) break;
            slot.x += shrink;
            slot.w -= shrink;
            if (slot.w > 0) break;
            prev.next = slot.next;
        }
        slot = this.mSlots;
        while (slot.next != null) {
            Slot nextSlot = (Slot)slot.next;
            if (slot.y == nextSlot.y) {
                slot.w += nextSlot.w;
                slot.next = nextSlot.next;
                continue;
            }
            slot = nextSlot;
        }
        this.mUsed += width * height;
        this.mRects = Inlist.push(this.mRects, r);
        return r;
    }

    public void clear() {
        this.mRects = null;
        this.mSlots = new Slot(1, 1, this.mWidth - 2);
    }

    public static TextureAtlas create(int width, int height, int depth) {
        if (depth != 1 && depth != 3 && depth != 4) {
            throw new IllegalArgumentException("invalid depth");
        }
        return new TextureAtlas(width, height);
    }

    public static class Rect
    extends Inlist<Rect> {
        public int x;
        public int y;
        public int w;
        public int h;

        public Rect(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public String toString() {
            return this.x + ":" + this.y + " " + this.w + "x" + this.h;
        }
    }

    public static class Slot
    extends Inlist<Slot> {
        public int x;
        public int y;
        public int w;

        public Slot(int x, int y, int w) {
            this.x = x;
            this.y = y;
            this.w = w;
        }
    }
}

