/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.utils.pool.Inlist;

public abstract class RenderBucket
extends Inlist<RenderBucket> {
    public static final int LINE = 0;
    public static final int TEXLINE = 1;
    public static final int POLYGON = 2;
    public static final int MESH = 3;
    public static final int EXTRUSION = 4;
    public static final int HAIRLINE = 5;
    public static final int SYMBOL = 6;
    public static final int BITMAP = 7;
    public static final int SDF = 8;
    public final int type;
    int level;
    protected int numVertices;
    protected int numIndices;
    protected final VertexData vertexItems;
    protected final VertexData indiceItems;
    static final VertexData EMPTY = new VertexData();
    final boolean quads;
    protected int vertexOffset;
    protected int indiceOffset;

    protected RenderBucket(int type, boolean indexed, boolean quads) {
        this.type = type;
        this.vertexItems = new VertexData();
        this.indiceItems = indexed ? new VertexData() : EMPTY;
        this.quads = quads;
    }

    protected void clear() {
        this.vertexItems.dispose();
        this.indiceItems.dispose();
        this.numVertices = 0;
        this.numIndices = 0;
    }

    protected void prepare() {
    }

    public int getVertexOffset() {
        return this.vertexOffset;
    }

    public int getIndiceOffset() {
        return this.indiceOffset;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setVertexOffset(int offset) {
        this.vertexOffset = offset;
    }

    protected void compile(ShortBuffer vboData, ShortBuffer iboData) {
        this.compileVertexItems(vboData);
        if (iboData != null) {
            this.compileIndicesItems(iboData);
        }
    }

    protected void compileVertexItems(ShortBuffer vboData) {
        this.vertexOffset = vboData.position() * 2;
        this.vertexItems.compile(vboData);
    }

    protected void compileIndicesItems(ShortBuffer iboData) {
        if (this.indiceItems == null || this.indiceItems.empty()) {
            return;
        }
        this.indiceOffset = iboData.position() * 2;
        this.indiceItems.compile(iboData);
    }
}

