/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import org.oscim.backend.CanvasAdapter;
import org.oscim.theme.ExternalRenderTheme;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlRenderThemeMenuCallback;
import org.oscim.theme.XmlThemeBuilder;

public class ThemeLoader {
    public static IRenderTheme load(String renderThemePath) throws IRenderTheme.ThemeException {
        return ThemeLoader.load(new ExternalRenderTheme(renderThemePath));
    }

    public static IRenderTheme load(String renderThemePath, XmlRenderThemeMenuCallback menuCallback) throws IRenderTheme.ThemeException {
        return ThemeLoader.load(new ExternalRenderTheme(renderThemePath, menuCallback));
    }

    public static IRenderTheme load(ThemeFile theme) throws IRenderTheme.ThemeException {
        IRenderTheme t = XmlThemeBuilder.read(theme);
        if (t != null) {
            t.scaleTextSize(CanvasAdapter.textScale + (CanvasAdapter.dpi / 240.0f - 1.0f) * 0.5f);
        }
        return t;
    }
}

