/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.canvas.Color;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.utils.FastMath;

public class AreaStyle
extends RenderStyle<AreaStyle> {
    private static final float FADE_START = 0.25f;
    private final int level;
    public final String style;
    public final int color;
    public final int fadeScale;
    public final int blendColor;
    public final int blendScale;
    public final TextureItem texture;
    public final int strokeColor;
    public final float strokeWidth;
    public final boolean mesh;

    public AreaStyle(int color) {
        this(0, color);
    }

    public AreaStyle(int level, int color) {
        this.level = level;
        this.style = "";
        this.fadeScale = -1;
        this.blendColor = 0;
        this.blendScale = -1;
        this.color = color;
        this.texture = null;
        this.strokeColor = color;
        this.strokeWidth = 1.0f;
        this.mesh = false;
    }

    public AreaStyle(AreaBuilder<?> b) {
        this.level = b.level;
        this.style = b.style;
        this.fadeScale = b.fadeScale;
        this.blendColor = b.blendColor;
        this.blendScale = b.blendScale;
        this.color = b.fillColor;
        this.texture = b.texture;
        this.strokeColor = b.strokeColor;
        this.strokeWidth = b.strokeWidth;
        this.mesh = b.mesh;
    }

    @Override
    public AreaStyle current() {
        return (AreaStyle)this.mCurrent;
    }

    @Override
    public void renderWay(RenderStyle.Callback cb) {
        cb.renderArea(this, this.level);
    }

    public boolean hasAlpha(int zoom) {
        if (!Color.isOpaque(this.color)) {
            return true;
        }
        if (this.texture != null) {
            return true;
        }
        if (this.blendScale < 0 && this.fadeScale < 0) {
            return false;
        }
        if (zoom >= this.blendScale && !Color.isOpaque(this.blendColor)) {
            return true;
        }
        return this.fadeScale <= zoom;
    }

    public float getFade(double scale) {
        if (this.fadeScale < 0) {
            return 1.0f;
        }
        float f = (float)(scale / (double)(1 << this.fadeScale)) - 1.0f;
        return FastMath.clamp(f, 0.25f, 1.0f);
    }

    public float getBlend(double scale) {
        if (this.blendScale < 0) {
            return 0.0f;
        }
        float f = (float)(scale / (double)(1 << this.blendScale)) - 1.0f;
        return FastMath.clamp(f, 0.0f, 1.0f);
    }

    public static AreaBuilder<?> builder() {
        return new AreaBuilder();
    }

    public static class AreaBuilder<T extends AreaBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public int fadeScale;
        public int blendColor;
        public int blendScale;
        public boolean mesh;
        public TextureItem texture;

        public T set(AreaStyle area) {
            if (area == null) {
                return this.reset();
            }
            this.level = area.level;
            this.style = area.style;
            this.fadeScale = area.fadeScale;
            this.blendColor = area.blendColor;
            this.blendScale = area.blendScale;
            this.fillColor = area.color;
            this.texture = area.texture;
            this.strokeColor = area.strokeColor;
            this.strokeWidth = area.strokeWidth;
            this.mesh = area.mesh;
            return (T)((AreaBuilder)this.self());
        }

        public T blendScale(int zoom) {
            this.blendScale = zoom;
            return (T)((AreaBuilder)this.self());
        }

        public T blendColor(int color) {
            this.blendColor = color;
            return (T)((AreaBuilder)this.self());
        }

        public T blendColor(String color) {
            this.blendColor = Color.parseColor(color);
            return (T)((AreaBuilder)this.self());
        }

        public T texture(TextureItem texture) {
            this.texture = texture;
            return (T)((AreaBuilder)this.self());
        }

        public T fadeScale(int zoom) {
            this.fadeScale = zoom;
            return (T)((AreaBuilder)this.self());
        }

        public T mesh(boolean mesh) {
            this.mesh = mesh;
            return (T)((AreaBuilder)this.self());
        }

        public T reset() {
            this.fillColor = -1;
            this.strokeColor = -16777216;
            this.strokeWidth = 0.0f;
            this.fadeScale = -1;
            this.blendScale = -1;
            this.blendColor = 0;
            this.style = null;
            this.texture = null;
            this.mesh = false;
            return (T)((AreaBuilder)this.self());
        }

        @Override
        public AreaStyle build() {
            return new AreaStyle(this);
        }
    }
}

