/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.canvas.Color;
import org.oscim.backend.canvas.Paint;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.theme.styles.RenderStyle;

public final class LineStyle
extends RenderStyle<LineStyle> {
    final int level;
    public final String style;
    public final float width;
    public final int color;
    public final Paint.Cap cap;
    public final boolean outline;
    public final boolean fixed;
    public final int fadeScale;
    public final float blur;
    public final int stipple;
    public final int stippleColor;
    public final float stippleWidth;
    public final TextureItem texture;
    public final boolean randomOffset;

    private LineStyle(LineBuilder<?> builder) {
        this.level = builder.level;
        this.style = builder.style;
        this.width = builder.strokeWidth;
        this.color = builder.fillColor;
        this.cap = builder.cap;
        this.outline = builder.outline;
        this.fixed = builder.fixed;
        this.fadeScale = builder.fadeScale;
        this.blur = builder.blur;
        this.stipple = builder.stipple;
        this.stippleColor = builder.stippleColor;
        this.stippleWidth = builder.stippleWidth;
        this.texture = builder.texture;
        this.randomOffset = builder.randomOffset;
    }

    public LineStyle(int level, String style, int color, float width, Paint.Cap cap, boolean fixed, int stipple, int stippleColor, float stippleWidth, int fadeScale, float blur, boolean isOutline, TextureItem texture, boolean randomOffset) {
        this.level = level;
        this.style = style;
        this.outline = isOutline;
        this.cap = cap;
        this.color = color;
        this.width = width;
        this.fixed = fixed;
        this.stipple = stipple;
        this.stippleColor = stippleColor;
        this.stippleWidth = stippleWidth;
        this.texture = texture;
        this.blur = blur;
        this.fadeScale = fadeScale;
        this.randomOffset = randomOffset;
    }

    public LineStyle(int stroke, float width) {
        this(0, "", stroke, width, Paint.Cap.BUTT, true, 0, 0, 0.0f, -1, 0.0f, false, null, true);
    }

    public LineStyle(int level, int stroke, float width) {
        this(level, "", stroke, width, Paint.Cap.BUTT, true, 0, 0, 0.0f, -1, 0.0f, false, null, true);
    }

    public LineStyle(int stroke, float width, Paint.Cap cap) {
        this(0, "", stroke, width, cap, true, 0, 0, 0.0f, -1, 0.0f, false, null, true);
    }

    @Override
    public void renderWay(RenderStyle.Callback cb) {
        cb.renderWay(this, this.level);
    }

    @Override
    public LineStyle current() {
        return (LineStyle)this.mCurrent;
    }

    public static LineBuilder<?> builder() {
        return new LineBuilder();
    }

    public static class LineBuilder<T extends LineBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public Paint.Cap cap;
        public boolean outline;
        public boolean fixed;
        public int fadeScale;
        public float blur;
        public int stipple;
        public int stippleColor;
        public float stippleWidth;
        public TextureItem texture;
        public boolean randomOffset;

        public T set(LineStyle line) {
            if (line == null) {
                return this.reset();
            }
            this.level = line.level;
            this.style = line.style;
            this.strokeWidth = line.width;
            this.fillColor = line.color;
            this.cap = line.cap;
            this.outline = line.outline;
            this.fixed = line.fixed;
            this.fadeScale = line.fadeScale;
            this.blur = line.blur;
            this.stipple = line.stipple;
            this.stippleColor = line.stippleColor;
            this.stippleWidth = line.stippleWidth;
            this.texture = line.texture;
            this.randomOffset = line.randomOffset;
            return (T)((LineBuilder)this.self());
        }

        public T reset() {
            this.level = -1;
            this.style = null;
            this.fillColor = -16777216;
            this.cap = Paint.Cap.ROUND;
            this.strokeWidth = 1.0f;
            this.fixed = false;
            this.fadeScale = -1;
            this.blur = 0.0f;
            this.stipple = 0;
            this.stippleWidth = 1.0f;
            this.stippleColor = -16777216;
            this.texture = null;
            this.randomOffset = true;
            return (T)((LineBuilder)this.self());
        }

        public T blur(float blur) {
            this.blur = blur;
            return (T)((LineBuilder)this.self());
        }

        public T fadeScale(int zoom) {
            this.fadeScale = zoom;
            return (T)((LineBuilder)this.self());
        }

        public T stipple(int width) {
            this.stipple = width;
            return (T)((LineBuilder)this.self());
        }

        public T stippleColor(int color) {
            this.stippleColor = color;
            return (T)((LineBuilder)this.self());
        }

        public T stippleColor(String color) {
            this.stippleColor = Color.parseColor(color);
            return (T)((LineBuilder)this.self());
        }

        public T stippleWidth(float width) {
            this.stippleWidth = width;
            return (T)((LineBuilder)this.self());
        }

        public T isOutline(boolean outline) {
            this.outline = outline;
            return (T)((LineBuilder)this.self());
        }

        @Override
        public LineStyle build() {
            return new LineStyle(this);
        }

        public T cap(Paint.Cap cap) {
            this.cap = cap;
            return (T)((LineBuilder)this.self());
        }

        public T fixed(boolean b) {
            this.fixed = b;
            return (T)((LineBuilder)this.self());
        }

        public T texture(TextureItem texture) {
            this.texture = texture;
            return (T)((LineBuilder)this.self());
        }

        public T randomOffset(boolean randomOffset) {
            this.randomOffset = randomOffset;
            return (T)((LineBuilder)this.self());
        }
    }
}

