/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.mapfile.IndexCache;
import org.oscim.tiling.source.mapfile.MapDatabase;
import org.oscim.tiling.source.mapfile.MapFileUtils;
import org.oscim.tiling.source.mapfile.MapInfo;
import org.oscim.tiling.source.mapfile.ReadBuffer;
import org.oscim.tiling.source.mapfile.header.MapFileHeader;
import org.oscim.tiling.source.mapfile.header.MapFileInfo;
import org.oscim.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapFileTileSource
extends TileSource {
    static final Logger log = LoggerFactory.getLogger(MapFileTileSource.class);
    private static final int INDEX_CACHE_SIZE = 64;
    private static final String READ_ONLY_MODE = "r";
    MapFileHeader fileHeader;
    MapFileInfo fileInfo;
    IndexCache databaseIndexCache;
    boolean experimental;
    File mapFile;
    RandomAccessFile mInputFile;
    private String preferredLanguage;
    private Callback callback;

    public MapFileTileSource() {
        super(0, 17);
    }

    String extractLocalized(String s) {
        if (this.callback != null) {
            return this.callback.extractLocalized(s);
        }
        return MapFileUtils.extract(s, this.preferredLanguage);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public boolean setMapFile(String filename) {
        this.setOption("file", filename);
        File file = new File(filename);
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        return file.canRead();
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    @Override
    public TileSource.OpenResult open() {
        if (!this.options.containsKey("file")) {
            return new TileSource.OpenResult("no map file set");
        }
        try {
            File file = new File((String)this.options.get("file"));
            if (!file.exists()) {
                return new TileSource.OpenResult("file does not exist: " + file);
            }
            if (!file.isFile()) {
                return new TileSource.OpenResult("not a file: " + file);
            }
            if (!file.canRead()) {
                return new TileSource.OpenResult("cannot read file: " + file);
            }
            this.mInputFile = new RandomAccessFile(file, READ_ONLY_MODE);
            long mFileSize = this.mInputFile.length();
            ReadBuffer mReadBuffer = new ReadBuffer(this.mInputFile);
            this.fileHeader = new MapFileHeader();
            TileSource.OpenResult openResult = this.fileHeader.readHeader(mReadBuffer, mFileSize);
            if (!openResult.isSuccess()) {
                this.close();
                return openResult;
            }
            this.fileInfo = this.fileHeader.getMapFileInfo();
            this.mapFile = file;
            this.databaseIndexCache = new IndexCache(this.mInputFile, 64);
            log.debug("File version: " + this.fileInfo.fileVersion);
            return TileSource.OpenResult.SUCCESS;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            this.close();
            return new TileSource.OpenResult(e.getMessage());
        }
    }

    @Override
    public ITileDataSource getDataSource() {
        try {
            return new MapDatabase(this);
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.mInputFile);
        this.mInputFile = null;
        this.fileHeader = null;
        this.fileInfo = null;
        this.mapFile = null;
        if (this.databaseIndexCache != null) {
            this.databaseIndexCache.destroy();
            this.databaseIndexCache = null;
        }
    }

    public MapInfo getMapInfo() {
        return this.fileInfo;
    }

    public static interface Callback {
        public String extractLocalized(String var1);
    }
}

