/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.util.Locale;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;

public final class OSMUtils {
    public static boolean isArea(MapElement mapElement) {
        boolean result = true;
        for (int i = 0; i < mapElement.tags.numTags; ++i) {
            Tag tag = mapElement.tags.tags[i];
            String key = tag.key.toLowerCase(Locale.ENGLISH);
            String value = tag.value.toLowerCase(Locale.ENGLISH);
            if ("area".equals(key)) {
                if ("yes".equals(value) || "y".equals(value) || "true".equals(value)) {
                    return true;
                }
                if ("no".equals(value) || "n".equals(value) || "false".equals(value)) {
                    return false;
                }
            }
            if ("aeroway".equals(key) || "building".equals(key) || "landuse".equals(key) || "leisure".equals(key) || "natural".equals(key)) {
                return true;
            }
            if ("highway".equals(key) || "barrier".equals(key)) {
                result = false;
            }
            if (!"railway".equals(key) || !"rail".equals(value) && !"tram".equals(value) && !"subway".equals(value) && !"monorail".equals(value) && !"narrow_gauge".equals(value) && !"preserved".equals(value) && !"light_rail".equals(value) && !"construction".equals(value)) continue;
            result = false;
        }
        return result;
    }

    private OSMUtils() {
    }
}

