/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.awt;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.oscim.awt.AwtBitmap;
import org.oscim.awt.AwtPaint;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;

public class AwtCanvas
implements Canvas {
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private BufferedImage bitmap;
    public Graphics2D canvas;
    private final AffineTransform tx = new AffineTransform();

    public AwtCanvas() {
    }

    public AwtCanvas(BufferedImage bitmap) {
        this.bitmap = bitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        if (this.canvas != null) {
            this.canvas.dispose();
        }
        AwtBitmap awtBitmap = (AwtBitmap)bitmap;
        this.bitmap = awtBitmap.bitmap;
        this.canvas = awtBitmap.bitmap.createGraphics();
        this.canvas.setComposite(AlphaComposite.getInstance(1, 0.0f));
        this.canvas.fillRect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        this.canvas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        this.canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.canvas.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.canvas.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.canvas.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.canvas.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    public void drawText(String text, float x, float y, Paint paint) {
        AwtPaint awtPaint = (AwtPaint)paint;
        if (awtPaint.stroke == null) {
            this.canvas.setColor(awtPaint.color);
            this.canvas.setFont(awtPaint.font);
            this.canvas.drawString(text, x, y);
        } else {
            this.canvas.setColor(awtPaint.color);
            this.canvas.setStroke(awtPaint.stroke);
            TextLayout tl = new TextLayout(text, awtPaint.font, this.canvas.getFontRenderContext());
            this.tx.setToIdentity();
            this.tx.translate(x, y);
            Shape s = tl.getOutline(this.tx);
            this.canvas.draw(s);
            this.canvas.setColor(awtPaint.color);
            this.canvas.fill(s);
        }
    }

    public void drawText(String text, float x, float y, Paint fill, Paint stroke) {
        AwtPaint fillPaint = (AwtPaint)fill;
        if (stroke == null) {
            this.canvas.setColor(fillPaint.color);
            this.canvas.setFont(fillPaint.font);
            this.canvas.drawString(text, x, y);
        } else {
            AwtPaint strokePaint = (AwtPaint)stroke;
            this.canvas.setColor(strokePaint.color);
            this.canvas.setStroke(strokePaint.stroke);
            TextLayout tl = new TextLayout(text, fillPaint.font, this.canvas.getFontRenderContext());
            this.tx.setToIdentity();
            this.tx.translate(x, y);
            Shape s = tl.getOutline(this.tx);
            this.canvas.draw(s);
            this.canvas.setColor(fillPaint.color);
            this.canvas.fill(s);
        }
    }

    public void drawBitmap(Bitmap bitmap, float x, float y) {
        this.canvas.drawImage((Image)((AwtBitmap)bitmap).bitmap, (int)x, (int)y, null);
    }

    public void drawLine(int x1, int y1, int x2, int y2, Paint paint) {
        AwtPaint awtPaint = (AwtPaint)paint;
        this.canvas.setColor(awtPaint.color);
        if (awtPaint.stroke != null) {
            this.canvas.setStroke(awtPaint.stroke);
        }
        this.canvas.drawLine(x1, y1, x2, y2);
    }

    public void fillColor(int color) {
        Color awtColor = color == 0 ? TRANSPARENT : new Color(color);
        Composite originalComposite = this.canvas.getComposite();
        this.canvas.setComposite(AlphaComposite.getInstance(2));
        this.canvas.setColor(awtColor);
        this.canvas.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.canvas.setComposite(originalComposite);
    }

    public int getHeight() {
        return this.bitmap != null ? this.bitmap.getHeight() : 0;
    }

    public int getWidth() {
        return this.bitmap != null ? this.bitmap.getWidth() : 0;
    }
}

