/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.awt;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.BufferUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwtBitmap
implements Bitmap {
    private static final Logger log = LoggerFactory.getLogger(AwtBitmap.class);
    BufferedImage bitmap;
    int width;
    int height;
    boolean internal;
    private static final IntBuffer tmpBuffer = BufferUtils.newIntBuffer(262144);
    private static final int[] tmpPixel = new int[262144];
    private static final boolean WRITE_TEX = false;
    private int dbgCnt;

    public AwtBitmap(int width, int height, int format) {
        this.bitmap = new BufferedImage(width, height, 2);
        this.width = width;
        this.height = height;
        this.internal = true;
    }

    AwtBitmap(InputStream inputStream) throws IOException {
        this.bitmap = ImageIO.read(inputStream);
        this.width = this.bitmap.getWidth();
        this.height = this.bitmap.getHeight();
        if (!this.bitmap.isAlphaPremultiplied() && this.bitmap.getType() == 2) {
            this.bitmap.coerceData(true);
        }
    }

    public AwtBitmap(BufferedImage bitmap) {
        this.bitmap = bitmap;
        this.width = this.bitmap.getWidth();
        this.height = this.bitmap.getHeight();
        if (!this.bitmap.isAlphaPremultiplied() && this.bitmap.getType() == 2) {
            this.bitmap.coerceData(true);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int[] getPixels() {
        return null;
    }

    @Override
    public void eraseColor(int transparent) {
    }

    @Override
    public void uploadToTexture(boolean replace) {
        IntBuffer buffer;
        int[] pixels;
        if (this.width * this.height < 262144) {
            pixels = tmpPixel;
            buffer = tmpBuffer;
            buffer.clear();
        } else {
            pixels = new int[this.width * this.height];
            buffer = BufferUtils.newIntBuffer(this.width * this.height);
        }
        this.bitmap.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        int n = this.width * this.height;
        for (int i = 0; i < n; ++i) {
            int c = pixels[i];
            if (c == 0) continue;
            float alpha = (float)(c >>> 24) / 255.0f;
            int r = (int)((float)(c & 0xFF) * alpha);
            int b = (int)((float)((c & 0xFF0000) >>> 16) * alpha);
            int g = (int)((float)((c & 0xFF00) >>> 8) * alpha);
            pixels[i] = c & 0xFF000000 | r << 16 | g << 8 | b;
        }
        buffer.put(pixels, 0, this.width * this.height);
        buffer.flip();
        Gdx.gl20.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5121, buffer);
    }

    @Override
    public void recycle() {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public byte[] getPngEncodedData() {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.bitmap, "png", outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly(outputStream);
        }
        return null;
    }
}

