/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.GLAdapter;
import org.oscim.core.Box;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.MapRenderer;
import org.oscim.utils.FastMath;
import org.oscim.utils.math.Interpolation;

public class LocationRenderer
extends LayerRenderer {
    private static final long ANIM_RATE = 50L;
    private static final long INTERVAL = 2000L;
    private static final float CIRCLE_SIZE = 60.0f;
    private static final int SHOW_ACCURACY_ZOOM = 16;
    private final Map mMap;
    private final Layer mLayer;
    private int mShaderProgram;
    private int hVertexPosition;
    private int hMatrixPosition;
    private int hScale;
    private int hPhase;
    private int hDirection;
    private final Point mIndicatorPosition = new Point();
    private final Point mScreenPoint = new Point();
    private final Box mBBox = new Box();
    private boolean mInitialized;
    private boolean mLocationIsVisible;
    private boolean mRunAnim;
    private long mAnimStart;
    private Callback mCallback;
    private final Point mLocation = new Point(Double.NaN, Double.NaN);
    private double mRadius;
    private Shader mShader = Shader.SHADER_1;
    private int mShowAccuracyZoom = 16;
    private static final String vShaderStr = "precision mediump float;uniform mat4 u_mvp;uniform float u_phase;uniform float u_scale;attribute vec2 a_pos;varying vec2 v_tex;void main() {  gl_Position = u_mvp * vec4(a_pos * u_scale * u_phase, 0.0, 1.0);  v_tex = a_pos;}";
    private static final String fShaderStr1 = "precision mediump float;varying vec2 v_tex;uniform float u_scale;uniform float u_phase;uniform vec2 u_dir;void main() {  float len = 1.0 - length(v_tex);  if (u_dir.x == 0.0 && u_dir.y == 0.0){  gl_FragColor = vec4(0.2, 0.2, 0.8, 1.0) * len;  } else {  float a = smoothstep(0.0, 2.0 / u_scale, len);  float b = 0.5 * smoothstep(4.0 / u_scale, 5.0 / u_scale, len);  float c = 0.5 * (1.0 - smoothstep(14.0 / u_scale, 16.0 / u_scale, 1.0 - len));  vec2 dir = normalize(v_tex);  float d = 1.0 - dot(dir, u_dir);   d = clamp(step(0.5, d), 0.4, 0.7);  a = d * (a - (b + c)) + c;  gl_FragColor = vec4(0.2, 0.2, 0.8, 1.0) * a;}}";
    private static final String fShaderStr2 = "precision mediump float;varying vec2 v_tex;uniform float u_scale;uniform float u_phase;uniform vec2 u_dir;void main() {  float len = 1.0 - length(v_tex);  float a = smoothstep(0.0, 2.0 / u_scale, len);  float b = 0.8 * smoothstep(3.0 / u_scale, 4.0 / u_scale, len);  float c = 0.5 * (1.0 - smoothstep(14.0 / u_scale, 16.0 / u_scale, 1.0 - len));  vec2 dir = normalize(v_tex);  float d = dot(dir, u_dir);   d = clamp(smoothstep(0.7, 0.7 + 2.0/u_scale, d) * len, 0.0, 1.0);  a = max(d, (a - (b + c)) + c);  gl_FragColor = vec4(0.2, 0.2, 0.8, 1.0) * a;}";

    public LocationRenderer(Map map, Layer layer) {
        this.mMap = map;
        this.mLayer = layer;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setLocation(double x, double y, double radius) {
        this.mLocation.x = x;
        this.mLocation.y = y;
        this.mRadius = radius;
    }

    public void setShader(Shader shader) {
        this.mShader = shader;
    }

    public void setShowAccuracyZoom(int showAccuracyZoom) {
        this.mShowAccuracyZoom = showAccuracyZoom;
    }

    public void animate(boolean enable) {
        if (this.mRunAnim == enable) {
            return;
        }
        this.mRunAnim = enable;
        if (!enable) {
            return;
        }
        Runnable action = new Runnable(){
            private long lastRun;

            @Override
            public void run() {
                if (!LocationRenderer.this.mRunAnim) {
                    return;
                }
                long diff = System.currentTimeMillis() - this.lastRun;
                LocationRenderer.this.mMap.postDelayed(this, Math.min(50L, diff));
                LocationRenderer.this.mMap.render();
                this.lastRun = System.currentTimeMillis();
            }
        };
        this.mAnimStart = System.currentTimeMillis();
        this.mMap.postDelayed(action, 50L);
    }

    private float animPhase() {
        return (float)((MapRenderer.frametime - this.mAnimStart) % 2000L) / 2000.0f;
    }

    @Override
    public void update(GLViewport v) {
        if (!this.mInitialized) {
            this.init();
            this.mInitialized = true;
        }
        if (!this.mLayer.isEnabled()) {
            this.setReady(false);
            return;
        }
        this.setReady(true);
        int width = this.mMap.getWidth();
        int height = this.mMap.getHeight();
        v.getBBox(this.mBBox, 0);
        double x = this.mLocation.x;
        double y = this.mLocation.y;
        if (!this.mBBox.contains(this.mLocation)) {
            x = FastMath.clamp(x, this.mBBox.xmin, this.mBBox.xmax);
            y = FastMath.clamp(y, this.mBBox.ymin, this.mBBox.ymax);
        }
        v.toScreenPoint(x, y, this.mScreenPoint);
        x = this.mScreenPoint.x + (double)(width / 2);
        y = this.mScreenPoint.y + (double)(height / 2);
        int visible = 0;
        if (x > (double)(width - 5)) {
            x = width;
        } else if (x < 5.0) {
            x = 0.0;
        } else {
            ++visible;
        }
        if (y > (double)(height - 5)) {
            y = height;
        } else if (y < 5.0) {
            y = 0.0;
        } else {
            ++visible;
        }
        this.mLocationIsVisible = visible == 2;
        v.fromScreenPoint(x, y, this.mIndicatorPosition);
    }

    @Override
    public void render(GLViewport v) {
        GLState.useProgram(this.mShaderProgram);
        GLState.blend(true);
        GLState.test(false, false);
        GLState.enableVertexArrays(this.hVertexPosition, -1);
        MapRenderer.bindQuadVertexVBO(this.hVertexPosition);
        float radius = 60.0f;
        this.animate(true);
        boolean viewShed = false;
        if (this.mLocationIsVisible) {
            if (v.pos.zoomLevel >= this.mShowAccuracyZoom) {
                radius = (float)(this.mRadius * v.pos.scale);
            }
            radius = Math.max(60.0f, radius);
            viewShed = true;
        }
        GLAdapter.gl.uniform1f(this.hScale, radius);
        double x = this.mIndicatorPosition.x - v.pos.x;
        double y = this.mIndicatorPosition.y - v.pos.y;
        double tileScale = (double)Tile.SIZE * v.pos.scale;
        v.mvp.setTransScale((float)(x * tileScale), (float)(y * tileScale), 1.0f);
        v.mvp.multiplyMM(v.viewproj, v.mvp);
        v.mvp.setAsUniform(this.hMatrixPosition);
        if (!viewShed) {
            float phase = Math.abs(this.animPhase() - 0.5f) * 2.0f;
            phase = Interpolation.swing.apply(phase);
            GLAdapter.gl.uniform1f(this.hPhase, 0.8f + phase * 0.2f);
        } else {
            GLAdapter.gl.uniform1f(this.hPhase, 1.0f);
        }
        if (viewShed && this.mLocationIsVisible) {
            float rotation = 0.0f;
            if (this.mCallback != null) {
                rotation = this.mCallback.getRotation();
            }
            GLAdapter.gl.uniform2f(this.hDirection, (float)Math.cos(Math.toRadians(rotation -= 90.0f)), (float)Math.sin(Math.toRadians(rotation)));
        } else {
            GLAdapter.gl.uniform2f(this.hDirection, 0.0f, 0.0f);
        }
        GLAdapter.gl.drawArrays(5, 0, 4);
    }

    private boolean init() {
        int shader = 0;
        switch (this.mShader) {
            case SHADER_1: {
                shader = GLShader.createProgram(vShaderStr, fShaderStr1);
                break;
            }
            case SHADER_2: {
                shader = GLShader.createProgram(vShaderStr, fShaderStr2);
            }
        }
        if (shader == 0) {
            return false;
        }
        this.mShaderProgram = shader;
        this.hVertexPosition = GLAdapter.gl.getAttribLocation(shader, "a_pos");
        this.hMatrixPosition = GLAdapter.gl.getUniformLocation(shader, "u_mvp");
        this.hPhase = GLAdapter.gl.getUniformLocation(shader, "u_phase");
        this.hScale = GLAdapter.gl.getUniformLocation(shader, "u_scale");
        this.hDirection = GLAdapter.gl.getUniformLocation(shader, "u_dir");
        return true;
    }

    public static interface Callback {
        public float getRotation();
    }

    public static enum Shader {
        SHADER_1,
        SHADER_2;

    }
}

