/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.GLAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.SyncPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextureItem
extends Inlist<TextureItem> {
    static final Logger log = LoggerFactory.getLogger(TextureItem.class);
    static final boolean dbg = false;
    private int id;
    public final int width;
    public final int height;
    public final boolean repeat;
    public int offset;
    public int indices;
    public Bitmap bitmap;
    private TextureItem ref;
    private int used = 0;
    boolean loaded;
    final TexturePool pool;
    public boolean mipmap;
    static final TexturePool NOPOOL = new TexturePool(0);
    static final ArrayList<Integer> disposedTextures = new ArrayList();

    private TextureItem(TexturePool pool, int id) {
        this(pool, id, pool.mWidth, pool.mHeight, false);
    }

    public TextureItem(Bitmap bitmap) {
        this(bitmap, false);
    }

    public TextureItem(Bitmap bitmap, boolean repeat) {
        this(NOPOOL, -1, bitmap.getWidth(), bitmap.getHeight(), repeat);
        this.bitmap = bitmap;
    }

    private TextureItem(TexturePool pool, int id, int width, int height, boolean repeat) {
        this.id = id;
        this.width = width;
        this.height = height;
        this.pool = pool;
        this.repeat = repeat;
    }

    public static TextureItem clone(TextureItem ti) {
        TextureItem clone = new TextureItem(NOPOOL, ti.id, ti.width, ti.height, ti.repeat);
        clone.id = ti.id;
        clone.ref = ti.ref == null ? ti : ti.ref;
        clone.loaded = ti.loaded;
        ++clone.ref.used;
        return clone;
    }

    public void upload() {
        if (this.loaded) {
            return;
        }
        if (this.ref == null) {
            this.pool.uploadTexture(this);
        } else {
            this.ref.upload();
            this.id = this.ref.id;
        }
        this.loaded = true;
    }

    public void bind() {
        if (this.loaded) {
            GLState.bindTex2D(this.id);
        } else {
            this.upload();
        }
    }

    @CheckReturnValue
    public TextureItem dispose() {
        TextureItem n = (TextureItem)this.next;
        this.next = null;
        this.pool.release(this);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeTextures() {
        ArrayList<Integer> arrayList = disposedTextures;
        synchronized (arrayList) {
            int size = disposedTextures.size();
            if (size > 0) {
                int[] tmp = new int[size];
                for (int i = 0; i < size; ++i) {
                    tmp[i] = disposedTextures.get(i);
                }
                disposedTextures.clear();
                GLUtils.glDeleteTextures(size, tmp);
            }
        }
    }

    public static class TexturePool
    extends SyncPool<TextureItem> {
        private final ArrayList<Bitmap> mBitmaps = new ArrayList(10);
        private final int mHeight;
        private final int mWidth;
        private final boolean mUseBitmapPool;
        private final boolean mMipmaps;
        protected int mTexCnt = 0;

        public TexturePool(int maxFill, int width, int height, boolean mipmap) {
            super(maxFill);
            this.mWidth = width;
            this.mHeight = height;
            this.mUseBitmapPool = true;
            this.mMipmaps = mipmap;
        }

        public TexturePool(int maxFill) {
            super(maxFill);
            this.mWidth = 0;
            this.mHeight = 0;
            this.mUseBitmapPool = false;
            this.mMipmaps = false;
        }

        @Override
        public TextureItem releaseAll(TextureItem t) {
            throw new RuntimeException("use TextureItem.dispose()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized TextureItem get() {
            TextureItem t = (TextureItem)super.get();
            if (!this.mUseBitmapPool) {
                return t;
            }
            ArrayList<Bitmap> arrayList = this.mBitmaps;
            synchronized (arrayList) {
                int size = this.mBitmaps.size();
                if (size == 0) {
                    t.bitmap = CanvasAdapter.newBitmap(this.mWidth, this.mHeight, 0);
                } else {
                    t.bitmap = this.mBitmaps.remove(size - 1);
                    t.bitmap.eraseColor(0);
                }
            }
            return t;
        }

        public synchronized TextureItem get(Bitmap bitmap) {
            TextureItem t = (TextureItem)super.get();
            t.bitmap = bitmap;
            return t;
        }

        @Override
        protected TextureItem createItem() {
            return new TextureItem(this, -1);
        }

        @Override
        protected boolean clearItem(TextureItem t) {
            if (t.used > 0) {
                return false;
            }
            if (t.ref != null) {
                if (t.ref.used == 0) {
                    t.ref.dispose();
                    return false;
                }
                t.ref.used--;
                return false;
            }
            t.loaded = false;
            if (this.mUseBitmapPool) {
                this.releaseBitmap(t);
            }
            return t.id >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void freeItem(TextureItem t) {
            if (t.ref == null && t.used == 0 && t.id >= 0) {
                --this.mTexCnt;
                ArrayList<Integer> arrayList = disposedTextures;
                synchronized (arrayList) {
                    disposedTextures.add(t.id);
                    t.id = -1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void releaseBitmap(TextureItem t) {
            if (t.bitmap == null) {
                return;
            }
            ArrayList<Bitmap> arrayList = this.mBitmaps;
            synchronized (arrayList) {
                this.mBitmaps.add(t.bitmap);
                t.bitmap = null;
            }
        }

        private void uploadTexture(TextureItem t) {
            if (t.bitmap == null) {
                throw new RuntimeException("Missing bitmap for texture");
            }
            if (t.id < 0) {
                int[] textureIds = GLUtils.glGenTextures(1);
                t.id = textureIds[0];
                t.mipmap |= this.mMipmaps;
                this.initTexture(t);
                ++this.mTexCnt;
                t.bitmap.uploadToTexture(false);
            } else {
                GLState.bindTex2D(t.id);
                t.bitmap.uploadToTexture(true);
            }
            if (t.mipmap) {
                GLAdapter.gl.generateMipmap(3553);
            }
            if (this.mUseBitmapPool) {
                this.releaseBitmap(t);
            }
        }

        protected void initTexture(TextureItem t) {
            GLState.bindTex2D(t.id);
            if (t.mipmap) {
                GLAdapter.gl.texParameterf(3553, 10241, 9987.0f);
            } else {
                GLAdapter.gl.texParameterf(3553, 10241, 9729.0f);
            }
            GLAdapter.gl.texParameterf(3553, 10240, 9729.0f);
            if (t.repeat) {
                GLAdapter.gl.texParameterf(3553, 10242, 10497.0f);
                GLAdapter.gl.texParameterf(3553, 10243, 10497.0f);
            } else {
                GLAdapter.gl.texParameterf(3553, 10242, 33071.0f);
                GLAdapter.gl.texParameterf(3553, 10243, 33071.0f);
            }
        }
    }
}

