/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.io.InputStream;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlRenderThemeMenuCallback;
import org.oscim.utils.Utils;

public class StreamRenderTheme
implements ThemeFile {
    private static final long serialVersionUID = 1L;
    private final InputStream mInputStream;
    private final XmlRenderThemeMenuCallback mMenuCallback;
    private final String mRelativePathPrefix;

    public StreamRenderTheme(String relativePathPrefix, InputStream inputStream) {
        this(relativePathPrefix, inputStream, null);
    }

    public StreamRenderTheme(String relativePathPrefix, InputStream inputStream, XmlRenderThemeMenuCallback menuCallback) {
        this.mRelativePathPrefix = relativePathPrefix;
        this.mInputStream = inputStream;
        this.mMenuCallback = menuCallback;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StreamRenderTheme)) {
            return false;
        }
        StreamRenderTheme other = (StreamRenderTheme)obj;
        if (this.mInputStream != other.mInputStream) {
            return false;
        }
        return Utils.equals(this.mRelativePathPrefix, other.mRelativePathPrefix);
    }

    @Override
    public XmlRenderThemeMenuCallback getMenuCallback() {
        return this.mMenuCallback;
    }

    @Override
    public String getRelativePathPrefix() {
        return this.mRelativePathPrefix;
    }

    @Override
    public InputStream getRenderThemeAsStream() throws IRenderTheme.ThemeException {
        return this.mInputStream;
    }
}

