/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.atlas.TextureRegion;

public class TextureAtlasUtils {
    private static final int MAX_ATLAS_SIZE = 1024;
    private static final int PAD = 2;

    /*
     * WARNING - void declaration
     */
    public static void createTextureRegions(Map<Object, Bitmap> inputMap, Map<Object, TextureRegion> outputMap, List<TextureAtlas> atlasList, boolean disposeBitmaps, boolean flipY) {
        int n;
        LinkedList<Map.Entry<Object, Bitmap>> list = new LinkedList<Map.Entry<Object, Bitmap>>(inputMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Object, Bitmap>>(){

            @Override
            public int compare(Map.Entry<Object, Bitmap> o1, Map.Entry<Object, Bitmap> o2) {
                int width1 = o1.getValue().getWidth();
                int width2 = o2.getValue().getWidth();
                int height1 = o1.getValue().getHeight();
                int height2 = o2.getValue().getHeight();
                return Math.max(width2, height2) - Math.max(width1, height1);
            }
        });
        LinkedHashMap sortedByValues = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedByValues.put(entry.getKey(), entry.getValue());
        }
        int completePixel = 4;
        for (Map.Entry entry : sortedByValues.entrySet()) {
            completePixel += (((Bitmap)entry.getValue()).getWidth() + 2) * (((Bitmap)entry.getValue()).getHeight() + 2);
        }
        int n2 = (int)Math.sqrt(completePixel = (int)((double)completePixel * 1.2));
        int n3 = n2 / 1024 + 1;
        if (n3 > 1) {
            n = 1024;
        }
        for (Map.Entry entry : sortedByValues.entrySet()) {
            BmpRectangleObject newObject = new BmpRectangleObject();
            newObject.bitmap = (Bitmap)entry.getValue();
            newObject.rec = new TextureAtlas.Rect(0, 0, newObject.bitmap.getWidth(), newObject.bitmap.getHeight());
            entry.setValue(newObject);
        }
        ArrayList<AtlasElement> atlases = new ArrayList<AtlasElement>();
        atlases.add(new AtlasElement());
        boolean bl = false;
        int maxLineHeight = 2;
        for (Map.Entry entry : sortedByValues.entrySet()) {
            void var11_18;
            BmpRectangleObject obj = (BmpRectangleObject)entry.getValue();
            AtlasElement atlas = (AtlasElement)atlases.get((int)var11_18);
            if (atlas.width + ((BmpRectangleObject)obj).rec.w + 2 > n) {
                if (atlas.height + maxLineHeight + ((BmpRectangleObject)obj).rec.h + 2 > 1024) {
                    atlas.width = n;
                    atlas.height += 2 + maxLineHeight;
                    ++var11_18;
                    atlas = new AtlasElement();
                    atlases.add(atlas);
                    ((BmpRectangleObject)obj).rec.x = 2 + atlas.width;
                    ((BmpRectangleObject)obj).rec.y = 2 + atlas.height;
                    atlas.width += ((BmpRectangleObject)obj).rec.w + 2;
                    maxLineHeight = ((BmpRectangleObject)obj).rec.h + 2;
                } else {
                    atlas.width = 0;
                    atlas.height += 2 + maxLineHeight;
                    ((BmpRectangleObject)obj).rec.x = 2 + atlas.width;
                    ((BmpRectangleObject)obj).rec.y = 2 + atlas.height;
                    atlas.width += ((BmpRectangleObject)obj).rec.w + 2;
                }
            } else {
                ((BmpRectangleObject)obj).rec.x = 2 + atlas.width;
                ((BmpRectangleObject)obj).rec.y = 2 + atlas.height;
                atlas.width += ((BmpRectangleObject)obj).rec.w + 2;
                maxLineHeight = Math.max(maxLineHeight, ((BmpRectangleObject)obj).rec.h + 2);
            }
            atlas.map.put(entry.getKey(), obj);
        }
        AtlasElement lastAtlas = (AtlasElement)atlases.get(atlases.size() - 1);
        lastAtlas.width = n;
        lastAtlas.height += maxLineHeight;
        for (AtlasElement atlas : atlases) {
            Bitmap atlasBitmap = CanvasAdapter.newBitmap(atlas.width, atlas.height, 0);
            Canvas canvas = CanvasAdapter.newCanvas();
            canvas.setBitmap(atlasBitmap);
            for (Map.Entry<Object, Object> entry : atlas.map.entrySet()) {
                BmpRectangleObject obj = (BmpRectangleObject)entry.getValue();
                if (((BmpRectangleObject)obj).rec.x + ((BmpRectangleObject)obj).rec.w > atlasBitmap.getWidth() || ((BmpRectangleObject)obj).rec.y + ((BmpRectangleObject)obj).rec.h > atlasBitmap.getHeight()) {
                    throw new RuntimeException("atlas region outside of textureRegion");
                }
                canvas.drawBitmap(obj.bitmap, ((BmpRectangleObject)obj).rec.x, flipY ? (float)(atlas.height - ((BmpRectangleObject)obj).rec.y - ((BmpRectangleObject)obj).rec.h) : (float)((BmpRectangleObject)obj).rec.y);
            }
            TextureAtlas textureAtlas = new TextureAtlas(atlasBitmap);
            atlasList.add(textureAtlas);
            for (Map.Entry<Object, Object> entry : atlas.map.entrySet()) {
                textureAtlas.addTextureRegion(entry.getKey(), ((BmpRectangleObject)entry.getValue()).rec);
                outputMap.put(entry.getKey(), textureAtlas.getTextureRegion(entry.getKey()));
            }
        }
        if (disposeBitmaps) {
            for (Bitmap bmp : inputMap.values()) {
                bmp.recycle();
            }
            inputMap.clear();
        }
    }

    private static class AtlasElement {
        int width = 0;
        int height = 0;
        Map<Object, Object> map = new LinkedHashMap<Object, Object>();

        private AtlasElement() {
        }
    }

    private static class BmpRectangleObject {
        private Bitmap bitmap;
        private TextureAtlas.Rect rec;

        private BmpRectangleObject() {
        }
    }
}

