/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.awt;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.oscim.awt.AwtBitmap;
import org.oscim.awt.AwtPaint;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;

public class AwtCanvas
implements Canvas {
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private BufferedImage bitmap;
    public Graphics2D canvas;
    private final AffineTransform tx = new AffineTransform();

    public AwtCanvas() {
    }

    public AwtCanvas(BufferedImage bitmap) {
        this.bitmap = bitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        if (this.canvas != null) {
            this.canvas.dispose();
        }
        AwtBitmap awtBitmap = (AwtBitmap)bitmap;
        this.bitmap = awtBitmap.bitmap;
        this.canvas = awtBitmap.bitmap.createGraphics();
        this.canvas.setComposite(AlphaComposite.getInstance(1, 0.0f));
        this.canvas.fillRect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        this.canvas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        this.canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.canvas.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.canvas.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.canvas.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.canvas.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    public void drawText(String text, float x, float y, Paint paint) {
        AwtPaint awtPaint = (AwtPaint)paint;
        if (awtPaint.stroke == null) {
            this.canvas.setColor(awtPaint.color);
            this.canvas.setFont(awtPaint.font);
            this.canvas.drawString(text, x, y);
        } else {
            this.canvas.setColor(awtPaint.color);
            this.canvas.setStroke(awtPaint.stroke);
            TextLayout tl = new TextLayout(text, awtPaint.font, this.canvas.getFontRenderContext());
            this.tx.setToIdentity();
            this.tx.translate(x, y);
            Shape s = tl.getOutline(this.tx);
            this.canvas.draw(s);
            this.canvas.setColor(awtPaint.color);
            this.canvas.fill(s);
        }
    }

    public void drawText(String text, float x, float y, Paint fill, Paint stroke) {
        AwtPaint fillPaint = (AwtPaint)fill;
        if (stroke == null) {
            this.canvas.setColor(fillPaint.color);
            this.canvas.setFont(fillPaint.font);
            this.canvas.drawString(text, x, y);
        } else {
            AwtPaint strokePaint = (AwtPaint)stroke;
            this.canvas.setColor(strokePaint.color);
            this.canvas.setStroke(strokePaint.stroke);
            TextLayout tl = new TextLayout(text, fillPaint.font, this.canvas.getFontRenderContext());
            this.tx.setToIdentity();
            this.tx.translate(x, y);
            Shape s = tl.getOutline(this.tx);
            this.canvas.draw(s);
            this.canvas.setColor(fillPaint.color);
            this.canvas.fill(s);
        }
    }

    public void drawBitmap(Bitmap bitmap, float x, float y) {
        BufferedImage src = ((AwtBitmap)bitmap).bitmap;
        if (src.isAlphaPremultiplied()) {
            int intX = (int)x;
            int intY = (int)y;
            int[] srcbuf = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
            int[] dstbuf = ((DataBufferInt)this.bitmap.getRaster().getDataBuffer()).getData();
            int width = intX + src.getWidth() > this.bitmap.getWidth() ? this.getWidth() - intX : src.getWidth();
            int height = intY + src.getHeight() > this.bitmap.getHeight() ? this.getHeight() - intY : src.getHeight();
            int dstoffs = intX + intY * this.bitmap.getWidth();
            int srcoffs = 0;
            int i = 0;
            while (i < height) {
                System.arraycopy(srcbuf, srcoffs, dstbuf, dstoffs, width);
                ++i;
                dstoffs += this.bitmap.getWidth();
                srcoffs += width;
            }
        } else {
            this.canvas.drawImage((Image)src, (int)x, (int)y, null);
        }
    }

    public void drawBitmapScaled(Bitmap bitmap) {
        Image scaledImage = ((AwtBitmap)bitmap).bitmap.getScaledInstance(this.bitmap.getWidth(), this.bitmap.getHeight(), 1);
        this.canvas.drawImage(scaledImage, 0, 0, this.bitmap.getWidth(), this.bitmap.getHeight(), null);
    }

    public void drawCircle(float x, float y, float radius, Paint paint) {
        AwtPaint awtPaint = (AwtPaint)paint;
        this.canvas.setColor(awtPaint.color);
        if (awtPaint.stroke != null) {
            this.canvas.setStroke(awtPaint.stroke);
        }
        float doubleRadius = radius * 2.0f;
        Paint.Style style = paint.getStyle();
        switch (style) {
            case FILL: {
                this.canvas.fillOval((int)(x - radius), (int)(y - radius), (int)doubleRadius, (int)doubleRadius);
                break;
            }
            case STROKE: {
                this.canvas.drawOval((int)(x - radius), (int)(y - radius), (int)doubleRadius, (int)doubleRadius);
            }
        }
    }

    public void drawLine(float x1, float y1, float x2, float y2, Paint paint) {
        AwtPaint awtPaint = (AwtPaint)paint;
        this.canvas.setColor(awtPaint.color);
        if (awtPaint.stroke != null) {
            this.canvas.setStroke(awtPaint.stroke);
        }
        this.canvas.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
    }

    public void fillColor(int color) {
        Color awtColor = color == 0 ? TRANSPARENT : new Color(color);
        Composite originalComposite = this.canvas.getComposite();
        this.canvas.setComposite(AlphaComposite.getInstance(color == 0 ? 1 : 3));
        this.canvas.setColor(awtColor);
        this.canvas.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.canvas.setComposite(originalComposite);
    }

    public int getHeight() {
        return this.bitmap != null ? this.bitmap.getHeight() : 0;
    }

    public int getWidth() {
        return this.bitmap != null ? this.bitmap.getWidth() : 0;
    }
}

