/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.gdx;

import com.badlogic.gdx.input.GestureDetector;
import org.oscim.event.Gesture;
import org.oscim.gdx.GdxMotionEvent;
import org.oscim.map.Map;

public class GestureHandlerImpl
extends GestureDetector.GestureAdapter {
    private final Map map;

    public GestureHandlerImpl(Map map) {
        this.map = map;
    }

    @Override
    public boolean longPress(float x, float y) {
        this.map.handleGesture(Gesture.LONG_PRESS, new GdxMotionEvent(0, x, y));
        return true;
    }

    @Override
    public boolean tap(float x, float y, int count, int button) {
        if (button == 0 && count == 2) {
            float pivotX = x - (float)(this.map.getWidth() / 2);
            float pivotY = y - (float)(this.map.getHeight() / 2);
            this.map.animator().animateZoom(300L, 2.0, pivotX, pivotY);
            this.map.updateMap(true);
            return false;
        }
        this.map.handleGesture(Gesture.TAP, new GdxMotionEvent(1, x, y, button));
        return false;
    }
}

