/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileDistanceSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobQueue {
    static final Logger log = LoggerFactory.getLogger(JobQueue.class);
    private int mCurrentJob = 0;
    private MapTile[] mJobs;

    public synchronized void setJobs(MapTile[] tiles) {
        this.mJobs = tiles;
        this.mCurrentJob = 0;
    }

    public synchronized void clear() {
        if (this.mJobs == null) {
            this.mCurrentJob = 0;
            return;
        }
        MapTile[] tiles = this.mJobs;
        int n = this.mJobs.length;
        for (int i = this.mCurrentJob; i < n; ++i) {
            MapTile t = tiles[i];
            if (t.state(18)) {
                t.setState((byte)1);
            } else {
                log.error("Wrong tile in queue {} {}", (Object)t, (Object)t.state());
            }
            tiles[i] = null;
        }
        this.mCurrentJob = 0;
        this.mJobs = null;
    }

    public synchronized boolean isEmpty() {
        return this.mJobs == null;
    }

    public synchronized MapTile poll() {
        int len;
        if (this.mJobs == null) {
            return null;
        }
        if (this.mCurrentJob == 0 && (len = this.mJobs.length) > 1) {
            TileDistanceSort.sort(this.mJobs, 0, len);
        }
        MapTile t = this.mJobs[this.mCurrentJob];
        this.mJobs[this.mCurrentJob] = null;
        if (++this.mCurrentJob == this.mJobs.length) {
            this.mJobs = null;
        }
        return t;
    }
}

