/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.layers.Layer;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.TileRenderer;
import org.oscim.map.Map;
import org.oscim.renderer.LayerRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TileLayer
extends Layer
implements Map.UpdateListener {
    static final Logger log = LoggerFactory.getLogger(TileLayer.class);
    private int mNumLoaders = 4;
    protected final TileManager mTileManager;
    protected TileLoader[] mTileLoader;

    public TileLayer(Map map, TileManager tileManager, TileRenderer renderer) {
        super(map);
        renderer.setTileManager(tileManager);
        this.mTileManager = tileManager;
        this.mRenderer = renderer;
    }

    public TileLayer(Map map, TileManager tileManager) {
        super(map);
        this.mTileManager = tileManager;
    }

    protected void setRenderer(TileRenderer renderer) {
        renderer.setTileManager(this.mTileManager);
        this.mRenderer = renderer;
    }

    protected abstract TileLoader createLoader();

    public TileRenderer tileRenderer() {
        return (TileRenderer)this.mRenderer;
    }

    protected void initLoader(int numLoaders) {
        this.mTileLoader = new TileLoader[numLoaders];
        for (int i = 0; i < numLoaders; ++i) {
            this.mTileLoader[i] = this.createLoader();
            this.mTileLoader[i].start();
        }
    }

    protected int getNumLoaders() {
        return this.mNumLoaders;
    }

    public void setNumLoaders(int num) {
        this.mNumLoaders = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMapEvent(Event event, MapPosition mapPosition) {
        if (event == Map.CLEAR_EVENT) {
            LayerRenderer layerRenderer = this.mRenderer;
            synchronized (layerRenderer) {
                this.tileRenderer().clearTiles();
                this.mTileManager.init();
            }
            if (this.mTileManager.update(mapPosition)) {
                this.notifyLoaders();
            }
        } else if (event == Map.POSITION_EVENT && this.mTileManager.update(mapPosition)) {
            this.notifyLoaders();
        }
    }

    @Override
    public void onDetach() {
        for (TileLoader loader : this.mTileLoader) {
            loader.pause();
            loader.finish();
            loader.dispose();
        }
    }

    void notifyLoaders() {
        for (TileLoader loader : this.mTileLoader) {
            loader.go();
        }
    }

    protected void pauseLoaders(boolean wait) {
        for (TileLoader loader : this.mTileLoader) {
            loader.cancel();
            if (loader.isPausing()) continue;
            loader.pause();
        }
        if (!wait) {
            return;
        }
        for (TileLoader loader : this.mTileLoader) {
            if (loader.isPausing()) continue;
            loader.awaitPausing();
        }
    }

    protected void resumeLoaders() {
        for (TileLoader loader : this.mTileLoader) {
            loader.proceed();
        }
    }

    public TileManager getManager() {
        return this.mTileManager;
    }
}

