/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.map;

import org.oscim.backend.CanvasAdapter;
import org.oscim.core.BoundingBox;
import org.oscim.core.GeoPoint;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.map.Map;
import org.oscim.map.ViewController;
import org.oscim.renderer.MapRenderer;
import org.oscim.utils.Easing;
import org.oscim.utils.FastMath;
import org.oscim.utils.ThreadUtils;
import org.oscim.utils.async.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Animator {
    static final Logger log = LoggerFactory.getLogger(Animator.class);
    public static final int ANIM_NONE = 0;
    public static final int ANIM_MOVE = 1;
    public static final int ANIM_SCALE = 2;
    public static final int ANIM_ROTATE = 4;
    public static final int ANIM_TILT = 8;
    public static final int ANIM_FLING = 16;
    private final Map mMap;
    private final MapPosition mCurPos = new MapPosition();
    private final MapPosition mStartPos = new MapPosition();
    private final MapPosition mDeltaPos = new MapPosition();
    private final Point mScroll = new Point();
    private final Point mPivot = new Point();
    private final Point mVelocity = new Point();
    private float mDuration = 500.0f;
    private long mAnimEnd = -1L;
    private Easing.Type mEasingType = Easing.Type.LINEAR;
    private int mState = 0;
    private Task updateTask = new Task(){

        @Override
        public int go(boolean canceled) {
            if (!canceled) {
                Animator.this.updateAnimation();
            }
            return 2;
        }
    };

    public Animator(Map map) {
        this.mMap = map;
    }

    public synchronized void animateTo(long duration, BoundingBox bbox) {
        this.animateTo(duration, bbox, Easing.Type.LINEAR);
    }

    public synchronized void animateTo(long duration, BoundingBox bbox, Easing.Type easingType) {
        this.animateTo(duration, bbox, easingType, 15);
    }

    public synchronized void animateTo(long duration, BoundingBox bbox, Easing.Type easingType, int state) {
        ThreadUtils.assertMainThread();
        this.mMap.getMapPosition(this.mStartPos);
        double dx = Math.abs(MercatorProjection.longitudeToX(bbox.getMaxLongitude()) - MercatorProjection.longitudeToX(bbox.getMinLongitude()));
        double dy = Math.abs(MercatorProjection.latitudeToY(bbox.getMinLatitude()) - MercatorProjection.latitudeToY(bbox.getMaxLatitude()));
        log.debug("anim bbox " + bbox);
        double zx = (double)this.mMap.getWidth() / (dx * (double)Tile.SIZE);
        double zy = (double)this.mMap.getHeight() / (dy * (double)Tile.SIZE);
        double newScale = Math.min(zx, zy);
        GeoPoint p = bbox.getCenterPoint();
        this.mDeltaPos.set(MercatorProjection.longitudeToX(p.getLongitude()) - this.mStartPos.x, MercatorProjection.latitudeToY(p.getLatitude()) - this.mStartPos.y, newScale - this.mStartPos.scale, -this.mStartPos.bearing, -this.mStartPos.tilt);
        this.animStart(duration, state, easingType);
    }

    public void animateTo(BoundingBox bbox) {
        this.animateTo(1000L, bbox, Easing.Type.LINEAR);
    }

    public void animateTo(long duration, GeoPoint geoPoint, double scale, boolean relative) {
        this.animateTo(duration, geoPoint, scale, relative, Easing.Type.LINEAR);
    }

    public void animateTo(long duration, GeoPoint geoPoint, double scale, boolean relative, Easing.Type easingType) {
        this.animateTo(duration, geoPoint, scale, relative, easingType, 3);
    }

    public void animateTo(long duration, GeoPoint geoPoint, double scale, boolean relative, Easing.Type easingType, int state) {
        ThreadUtils.assertMainThread();
        this.mMap.getMapPosition(this.mStartPos);
        if (relative) {
            scale = this.mStartPos.scale * scale;
        }
        scale = this.mMap.viewport().limitScale(scale);
        this.mDeltaPos.set(MercatorProjection.longitudeToX(geoPoint.getLongitude()) - this.mStartPos.x, MercatorProjection.latitudeToY(geoPoint.getLatitude()) - this.mStartPos.y, scale - this.mStartPos.scale, 0.0f, 0.0f);
        this.animStart(duration, state, easingType);
    }

    public void animateTo(GeoPoint p) {
        this.animateTo(500L, p, 1.0, true, Easing.Type.LINEAR);
    }

    public void animateTo(long duration, MapPosition pos) {
        this.animateTo(duration, pos, Easing.Type.LINEAR);
    }

    public void animateTo(long duration, MapPosition pos, Easing.Type easingType) {
        this.animateTo(duration, pos, easingType, 15);
    }

    public void animateTo(long duration, MapPosition pos, Easing.Type easingType, int state) {
        ThreadUtils.assertMainThread();
        this.mMap.getMapPosition(this.mStartPos);
        pos.scale = this.mMap.viewport().limitScale(pos.scale);
        this.mDeltaPos.set(pos.x - this.mStartPos.x, pos.y - this.mStartPos.y, pos.scale - this.mStartPos.scale, pos.bearing - this.mStartPos.bearing, this.mMap.viewport().limitTilt(pos.tilt) - this.mStartPos.tilt);
        this.animStart(duration, state, easingType);
    }

    public void animateZoom(long duration, double scaleBy, float pivotX, float pivotY) {
        this.animateZoom(duration, scaleBy, pivotX, pivotY, Easing.Type.LINEAR);
    }

    public void animateZoom(long duration, double scaleBy, float pivotX, float pivotY, Easing.Type easingType) {
        ThreadUtils.assertMainThread();
        this.mMap.getMapPosition(this.mCurPos);
        scaleBy = this.mState == 2 ? (this.mStartPos.scale + this.mDeltaPos.scale) * scaleBy : this.mCurPos.scale * scaleBy;
        this.mStartPos.copy(this.mCurPos);
        scaleBy = this.mMap.viewport().limitScale(scaleBy);
        if (scaleBy == 0.0) {
            return;
        }
        this.mDeltaPos.scale = scaleBy - this.mStartPos.scale;
        this.mPivot.x = pivotX;
        this.mPivot.y = pivotY;
        this.animStart(duration, 2, easingType);
    }

    public void animateFling(float velocityX, float velocityY, int xmin, int xmax, int ymin, int ymax) {
        ThreadUtils.assertMainThread();
        if (velocityX * velocityX + velocityY * velocityY < 2048.0f) {
            return;
        }
        this.mMap.getMapPosition(this.mStartPos);
        this.mScroll.x = 0.0;
        this.mScroll.y = 0.0;
        float duration = 500.0f;
        float flingFactor = 160.0f / CanvasAdapter.dpi;
        this.mVelocity.x = velocityX * flingFactor;
        this.mVelocity.y = velocityY * flingFactor;
        this.mVelocity.x = FastMath.clamp(this.mVelocity.x, (double)xmin, (double)xmax);
        this.mVelocity.y = FastMath.clamp(this.mVelocity.y, (double)ymin, (double)ymax);
        if (Double.isNaN(this.mVelocity.x) || Double.isNaN(this.mVelocity.y)) {
            log.debug("fling NaN!");
            return;
        }
        this.animStart(duration, 16, Easing.Type.LINEAR);
    }

    private void animStart(float duration, int state, Easing.Type easingType) {
        if (!this.isActive()) {
            this.mMap.events.fire(Map.ANIM_START, this.mMap.mMapPosition);
        }
        this.mCurPos.copy(this.mStartPos);
        this.mState = state;
        this.mDuration = duration;
        this.mAnimEnd = System.currentTimeMillis() + (long)duration;
        this.mEasingType = easingType;
        this.mMap.render();
    }

    void updateAnimation() {
        boolean changed;
        if (this.mState == 0) {
            return;
        }
        long millisLeft = this.mAnimEnd - MapRenderer.frametime;
        ViewController v = this.mMap.viewport();
        if (v.getMapPosition(this.mCurPos)) {
            log.debug("cancel anim - changed");
            this.cancel();
            return;
        }
        float adv = FastMath.clamp(1.0f - (float)millisLeft / this.mDuration, 1.0E-6f, 1.0f);
        if (this.mEasingType != Easing.Type.LINEAR) {
            adv = Easing.ease(0L, (long)(adv * 9.223372E18f), 9.223372E18f, this.mEasingType);
            adv = FastMath.clamp(adv, 0.0f, 1.0f);
        }
        double scaleAdv = 1.0;
        if ((this.mState & 2) != 0) {
            scaleAdv = this.doScale(v, adv);
        }
        if ((this.mState & 1) != 0) {
            v.moveTo(this.mStartPos.x + this.mDeltaPos.x * ((double)adv / scaleAdv), this.mStartPos.y + this.mDeltaPos.y * ((double)adv / scaleAdv));
        }
        if ((this.mState & 0x10) != 0) {
            adv = (float)Math.sqrt(adv);
            double dx = this.mVelocity.x * (double)adv;
            double dy = this.mVelocity.y * (double)adv;
            if (dx - this.mScroll.x != 0.0 || dy - this.mScroll.y != 0.0) {
                v.moveMap((float)(dx - this.mScroll.x), (float)(dy - this.mScroll.y));
                this.mScroll.x = dx;
                this.mScroll.y = dy;
            }
        }
        if ((this.mState & 4) != 0) {
            v.setRotation(this.mStartPos.bearing + this.mDeltaPos.bearing * adv);
        }
        if ((this.mState & 8) != 0) {
            v.setTilt(this.mStartPos.tilt + this.mDeltaPos.tilt * adv);
        }
        if (millisLeft <= 0L) {
            this.cancel();
        }
        if (changed = v.getMapPosition(this.mCurPos)) {
            this.mMap.updateMap(true);
        } else {
            this.mMap.postDelayed(this.updateTask, 10L);
        }
    }

    private double doScale(ViewController v, float adv) {
        double newScale = this.mStartPos.scale + this.mDeltaPos.scale * Math.sqrt(adv);
        v.scaleMap((float)(newScale / this.mCurPos.scale), (float)this.mPivot.x, (float)this.mPivot.y);
        return newScale / (this.mStartPos.scale + this.mDeltaPos.scale);
    }

    public void cancel() {
        this.mState = 0;
        this.mPivot.x = 0.0;
        this.mPivot.y = 0.0;
        this.mMap.events.fire(Map.ANIM_END, this.mMap.mMapPosition);
    }

    public boolean isActive() {
        return this.mState != 0;
    }

    public MapPosition getEndPosition() {
        return this.mDeltaPos;
    }
}

