/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ShortBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.TextureItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextureBucket
extends RenderBucket {
    static final Logger log = LoggerFactory.getLogger(TextureBucket.class);
    public static final int INDICES_PER_SPRITE = 6;
    static final int VERTICES_PER_SPRITE = 4;
    static final int SHORTS_PER_VERTICE = 6;
    public static final int TEXTURE_HEIGHT = 256;
    public static final int TEXTURE_WIDTH = 1024;
    static final int POOL_FILL = 4;
    public static final TextureItem.TexturePool pool = new TextureItem.TexturePool(4, 1024, 256, false);
    public TextureItem textures;
    public boolean fixed;
    static Shader shader;

    public TextureBucket(int type) {
        super(type, false, true);
    }

    @Override
    protected void compile(ShortBuffer vboData, ShortBuffer iboData) {
        TextureItem t = this.textures;
        while (t != null) {
            t.upload();
            t = (TextureItem)t.next;
        }
        this.compileVertexItems(vboData);
    }

    @Override
    protected void clear() {
        while (this.textures != null) {
            this.textures = this.textures.dispose();
        }
        super.clear();
    }

    public TextureItem getTextures() {
        return this.textures;
    }

    public void render(int offset, int numIndices) {
        GLAdapter.gl.vertexAttribPointer(TextureBucket.shader.aPos, 4, 5122, false, 12, offset);
        GLAdapter.gl.vertexAttribPointer(TextureBucket.shader.aTexCoord, 2, 5122, false, 12, offset + 8);
        GLAdapter.gl.drawElements(4, numIndices, 5123, 0);
    }

    public static final class Renderer {
        static void init() {
            shader = new Shader();
            pool.init(0);
        }

        public static RenderBucket draw(RenderBucket b, GLViewport v, float scale) {
            GLState.test(false, false);
            GLState.blend(true);
            shader.useProgram();
            TextureBucket tb = (TextureBucket)b;
            GLAdapter.gl.uniform1f(TextureBucket.shader.uScale, tb.fixed ? 1.0f / scale : 1.0f);
            GLAdapter.gl.uniform1f(TextureBucket.shader.uCoordScale, MapRenderer.COORD_SCALE);
            v.proj.setAsUniform(TextureBucket.shader.uProj);
            v.mvp.setAsUniform(TextureBucket.shader.uMV);
            MapRenderer.bindQuadIndicesVBO();
            TextureItem t = tb.textures;
            while (t != null) {
                GLAdapter.gl.uniform2f(TextureBucket.shader.uTexSize, 1.0f / ((float)t.width * MapRenderer.COORD_SCALE), 1.0f / ((float)t.height * MapRenderer.COORD_SCALE));
                t.bind();
                for (int i = 0; i < t.indices; i += 3072) {
                    int off = (t.offset + i) * 8 + tb.vertexOffset;
                    int numIndices = t.indices - i;
                    if (numIndices > 3072) {
                        numIndices = 3072;
                    }
                    tb.render(off, numIndices);
                }
                t = (TextureItem)t.next;
            }
            return (RenderBucket)b.next;
        }
    }

    static class Shader
    extends GLShader {
        int uMV;
        int uProj;
        int uScale;
        int uCoordScale;
        int uTexSize;
        int aPos;
        int aTexCoord;

        Shader() {
            if (!this.create("texture_layer")) {
                return;
            }
            this.uMV = this.getUniform("u_mv");
            this.uProj = this.getUniform("u_proj");
            this.uScale = this.getUniform("u_scale");
            this.uCoordScale = this.getUniform("u_coord_scale");
            this.uTexSize = this.getUniform("u_div");
            this.aPos = this.getAttrib("vertex");
            this.aTexCoord = this.getAttrib("tex_coord");
        }

        @Override
        public boolean useProgram() {
            if (super.useProgram()) {
                GLState.enableVertexArrays(this.aPos, this.aTexCoord);
                return true;
            }
            return false;
        }
    }
}

