/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.util.ArrayList;
import java.util.List;
import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.source.mapfile.MapDatabase;
import org.oscim.tiling.source.mapfile.MultiMapDataSink;
import org.oscim.tiling.source.mapfile.MultiMapFileTileSource;

public class MultiMapDatabase
implements ITileDataSource {
    private final List<MapDatabase> mapDatabases = new ArrayList<MapDatabase>();
    private final MultiMapFileTileSource tileSource;

    public MultiMapDatabase(MultiMapFileTileSource tileSource) {
        this.tileSource = tileSource;
    }

    public boolean add(MapDatabase mapDatabase) {
        if (this.mapDatabases.contains(mapDatabase)) {
            throw new IllegalArgumentException("Duplicate map database");
        }
        return this.mapDatabases.add(mapDatabase);
    }

    @Override
    public void query(MapTile tile, ITileDataSink mapDataSink) {
        MultiMapDataSink multiMapDataSink = new MultiMapDataSink(mapDataSink);
        for (MapDatabase mapDatabase : this.mapDatabases) {
            int[] zoomLevels = this.tileSource.getZoomsByTileSource().get(mapDatabase.getTileSource());
            if (zoomLevels != null && (zoomLevels[0] > tile.zoomLevel || tile.zoomLevel > zoomLevels[1])) continue;
            mapDatabase.query(tile, multiMapDataSink);
        }
        mapDataSink.completed(multiMapDataSink.getResult());
    }

    @Override
    public void dispose() {
        for (MapDatabase mapDatabase : this.mapDatabases) {
            mapDatabase.dispose();
        }
    }

    @Override
    public void cancel() {
        for (MapDatabase mapDatabase : this.mapDatabases) {
            mapDatabase.cancel();
        }
    }
}

