/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

public class ArrayUtils {
    public static <T> void reverse(T[] data) {
        ArrayUtils.reverse(data, 0, data.length);
    }

    public static <T> void reverse(T[] data, int left, int right) {
        --right;
        while (left < right) {
            T tmp = data[left];
            data[left] = data[right];
            data[right] = tmp;
            ++left;
            --right;
        }
    }

    public static void reverse(short[] data, int left, int right, int stride) {
        right -= stride;
        while (left < right) {
            for (int i = 0; i < stride; ++i) {
                short tmp = data[left + i];
                data[left + i] = data[right + i];
                data[right + i] = tmp;
            }
            left += stride;
            right -= stride;
        }
    }

    public static void reverse(byte[] data, int left, int right) {
        --right;
        while (left < right) {
            byte tmp = data[left];
            data[left] = data[right];
            data[right] = tmp;
            ++left;
            --right;
        }
    }

    public static double parseNumber(char[] str, int pos, int end) {
        double val;
        boolean neg;
        block14: {
            neg = false;
            if (str[pos] == '-') {
                neg = true;
                ++pos;
            }
            val = 0.0;
            int pre = 0;
            char c = '\u0000';
            while (pos < end) {
                c = str[pos];
                if (c < '0' || c > '9') {
                    if (pre != 0) break;
                    throw new NumberFormatException("s " + c);
                }
                val = val * 10.0 + (double)(c - 48);
                ++pos;
                ++pre;
            }
            if (pre == 0) {
                throw new NumberFormatException();
            }
            if (c == '.') {
                float div = 10.0f;
                ++pos;
                while (pos < end && (c = str[pos]) >= '0' && c <= '9') {
                    val += (double)((float)(c - 48) / div);
                    div *= 10.0f;
                    ++pos;
                }
            }
            if (c != 'e' && c != 'E') break block14;
            int dir = 1;
            if (str[++pos] == '-') {
                dir = -1;
                ++pos;
            }
            while (pos < end && str[pos] == '0') {
                ++pos;
            }
            int shift = 0;
            pre = 0;
            while (pos < end) {
                c = str[pos];
                if (c < '0' || c > '9') {
                    if (pre != 0) break;
                    throw new NumberFormatException("e " + c);
                }
                shift = shift * 10 + (c - 48);
                ++pos;
                ++pre;
            }
            if (dir > 0) {
                while (shift-- > 0) {
                    val *= 10.0;
                }
            } else {
                while (shift-- > 0) {
                    val /= 10.0;
                }
            }
        }
        return neg ? -val : val;
    }

    public static boolean withinRange(float[] vec, float min, float max) {
        for (float v : vec) {
            if (!(v < min) && !(v > max)) continue;
            return false;
        }
        return true;
    }

    public static void setBox2D(float[] bbox, float xmin, float ymin, float xmax, float ymax) {
        bbox[0] = bbox[2] = xmin;
        bbox[4] = bbox[6] = xmax;
        bbox[1] = bbox[7] = ymin;
        bbox[3] = bbox[5] = ymax;
    }
}

