/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.awt;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.oscim.awt.AwtBitmap;
import org.oscim.awt.AwtCanvas;
import org.oscim.awt.AwtPaint;
import org.oscim.awt.AwtSvgBitmap;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.Platform;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;

public class AwtGraphics
extends CanvasAdapter {
    static final BufferedImage image = new BufferedImage(1, 1, 2);
    static final Graphics2D canvas = image.createGraphics();

    public static void init() {
        CanvasAdapter.init((CanvasAdapter)new AwtGraphics());
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        CanvasAdapter.platform = os.contains("win") ? Platform.WINDOWS : (os.contains("mac") ? Platform.MACOS : Platform.LINUX);
    }

    public static BufferedImage getBitmap(Bitmap bitmap) {
        return ((AwtBitmap)bitmap).bitmap;
    }

    private AwtGraphics() {
    }

    public Paint newPaintImpl() {
        return new AwtPaint();
    }

    public Bitmap newBitmapImpl(int width, int height, int format) {
        return new AwtBitmap(width, height, format);
    }

    public Canvas newCanvasImpl() {
        return new AwtCanvas();
    }

    static synchronized FontMetrics getFontMetrics(Font font) {
        canvas.setFont(font);
        FontMetrics fm = canvas.getFontMetrics();
        return fm;
    }

    static synchronized float getTextWidth(FontMetrics fm, String text) {
        return fm.stringWidth(text);
    }

    public Bitmap decodeBitmapImpl(InputStream inputStream) throws IOException {
        return new AwtBitmap(inputStream);
    }

    public Bitmap decodeSvgBitmapImpl(InputStream inputStream, int width, int height, int percent) throws IOException {
        return new AwtSvgBitmap(inputStream, width, height, percent);
    }

    public Bitmap loadBitmapAssetImpl(String relativePathPrefix, String src, int width, int height, int percent) throws IOException {
        return AwtGraphics.createBitmap((String)relativePathPrefix, (String)src, (int)width, (int)height, (int)percent);
    }

    static {
        canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        canvas.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        canvas.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        canvas.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        canvas.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }
}

