/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.geojson;

import java.util.Map;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.tiling.source.geojson.GeoJsonTileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmRoadLineJsonTileSource
extends GeoJsonTileSource {
    static final Logger log = LoggerFactory.getLogger(OsmRoadLineJsonTileSource.class);
    Tag mTagTunnel = new Tag("tunnel", "yes");
    Tag mTagBridge = new Tag("bridge", "yes");

    public OsmRoadLineJsonTileSource() {
        super("http://tile.openstreetmap.us/vectiles-highroad");
    }

    @Override
    public void decodeTags(MapElement mapElement, Map<String, Object> properties) {
        String highway = null;
        boolean isLink = false;
        mapElement.layer = 5;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || "no".equals(value)) continue;
            if ("highway".equals(key) && value instanceof String) {
                highway = (String)entry.getValue();
                continue;
            }
            if ("is_link".equals(key)) {
                isLink = "yes".equals(value);
                continue;
            }
            if ("is_tunnel".equals(key)) {
                mapElement.tags.add(this.mTagTunnel);
                continue;
            }
            if ("is_bridge".equals(key)) {
                mapElement.tags.add(this.mTagBridge);
                continue;
            }
            if ("sort_key".equals(key)) {
                if (!(value instanceof Integer)) continue;
                mapElement.layer = 5 + (Integer)value;
                continue;
            }
            if (!"railway".equals(key) || !(value instanceof String)) continue;
            mapElement.tags.add(new Tag("railway", (String)value));
        }
        if (highway == null) {
            return;
        }
        if (isLink) {
            highway = highway + "_link";
        }
        mapElement.tags.add(new Tag("highway", highway));
    }

    @Override
    public Tag rewriteTag(String key, Object value) {
        if ("kind".equals(key)) {
            return null;
        }
        if (value == null) {
            return null;
        }
        String val = value instanceof String ? (String)value : String.valueOf(value);
        return new Tag(key, val);
    }
}

