/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.ArrayList;

public class Triangulator {
    private static final float EPSILON = 1.0E-10f;
    private final PointList poly = new PointList();
    private final PointList tris = new PointList();
    private boolean tried;

    public void addPolyPoint(float x, float y) {
        this.poly.add(new Point(x, y));
    }

    public boolean triangulate() {
        this.tried = true;
        boolean worked = Triangulator.process(this.poly, this.tris);
        return worked;
    }

    public int getTriangleCount() {
        if (!this.tried) {
            throw new RuntimeException("Call triangulate() before accessing triangles");
        }
        return this.tris.size() / 3;
    }

    public float[] getTrianglePoint(int tri, int i) {
        if (!this.tried) {
            throw new RuntimeException("Call triangulate() before accessing triangles");
        }
        return this.tris.get(tri * 3 + i).toArray();
    }

    private static float area(PointList contour) {
        int n = contour.size();
        float A = 0.0f;
        int p = n - 1;
        int q = 0;
        while (q < n) {
            Point contourP = contour.get(p);
            Point contourQ = contour.get(q);
            A += contourP.getX() * contourQ.getY() - contourQ.getX() * contourP.getY();
            p = q++;
        }
        return A * 0.5f;
    }

    private static boolean insideTriangle(float Ax, float Ay, float Bx, float By, float Cx, float Cy, float Px, float Py) {
        float ax = Cx - Bx;
        float ay = Cy - By;
        float bx = Ax - Cx;
        float by = Ay - Cy;
        float cx = Bx - Ax;
        float cy = By - Ay;
        float apx = Px - Ax;
        float apy = Py - Ay;
        float bpx = Px - Bx;
        float bpy = Py - By;
        float cpx = Px - Cx;
        float cpy = Py - Cy;
        float aCROSSbp = ax * bpy - ay * bpx;
        float cCROSSap = cx * apy - cy * apx;
        float bCROSScp = bx * cpy - by * cpx;
        return aCROSSbp >= 0.0f && bCROSScp >= 0.0f && cCROSSap >= 0.0f;
    }

    private static boolean snip(PointList contour, int u, int v, int w, int n, int[] V) {
        float Ax = contour.get(V[u]).getX();
        float Ay = contour.get(V[u]).getY();
        float Bx = contour.get(V[v]).getX();
        float By = contour.get(V[v]).getY();
        float Cx = contour.get(V[w]).getX();
        float Cy = contour.get(V[w]).getY();
        if (1.0E-10f > (Bx - Ax) * (Cy - Ay) - (By - Ay) * (Cx - Ax)) {
            return false;
        }
        for (int p = 0; p < n; ++p) {
            float Py;
            float Px;
            if (p == u || p == v || p == w || !Triangulator.insideTriangle(Ax, Ay, Bx, By, Cx, Cy, Px = contour.get(V[p]).getX(), Py = contour.get(V[p]).getY())) continue;
            return false;
        }
        return true;
    }

    private static boolean process(PointList contour, PointList result) {
        int v;
        int n = contour.size();
        if (n < 3) {
            return false;
        }
        int[] V = new int[n];
        if (0.0f < Triangulator.area(contour)) {
            for (v = 0; v < n; ++v) {
                V[v] = v;
            }
        } else {
            for (v = 0; v < n; ++v) {
                V[v] = n - 1 - v;
            }
        }
        int nv = n;
        int count = 2 * nv;
        int v2 = nv - 1;
        while (nv > 2) {
            int w;
            if (0 >= count--) {
                return false;
            }
            int u = v2;
            if (nv <= u) {
                u = 0;
            }
            if (nv <= (v2 = u + 1)) {
                v2 = 0;
            }
            if (nv <= (w = v2 + 1)) {
                w = 0;
            }
            if (!Triangulator.snip(contour, u, v2, w, nv, V)) continue;
            int a = V[u];
            int b = V[v2];
            int c = V[w];
            result.add(contour.get(a));
            result.add(contour.get(b));
            result.add(contour.get(c));
            int s = v2;
            for (int t = v2 + 1; t < nv; ++t) {
                V[s] = V[t];
                ++s;
            }
            count = 2 * --nv;
        }
        return true;
    }

    private class PointList {
        private final ArrayList<Point> points = new ArrayList();

        public void add(Point point) {
            this.points.add(point);
        }

        public int size() {
            return this.points.size();
        }

        public Point get(int i) {
            return this.points.get(i);
        }
    }

    private class Point {
        private final float x;
        private final float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float[] toArray() {
            return new float[]{this.x, this.y};
        }
    }
}

