/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapnik;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.InflaterInputStream;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.source.PbfDecoder;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.Pool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileDecoder
extends PbfDecoder {
    static final Logger log = LoggerFactory.getLogger(TileDecoder.class);
    private static final int TAG_TILE_LAYERS = 3;
    private static final int TAG_LAYER_VERSION = 15;
    private static final int TAG_LAYER_NAME = 1;
    private static final int TAG_LAYER_FEATURES = 2;
    private static final int TAG_LAYER_KEYS = 3;
    private static final int TAG_LAYER_VALUES = 4;
    private static final int TAG_LAYER_EXTENT = 5;
    private static final int TAG_FEATURE_ID = 1;
    private static final int TAG_FEATURE_TAGS = 2;
    private static final int TAG_FEATURE_TYPE = 3;
    private static final int TAG_FEATURE_GEOMETRY = 4;
    private static final int TAG_VALUE_STRING = 1;
    private static final int TAG_VALUE_FLOAT = 2;
    private static final int TAG_VALUE_DOUBLE = 3;
    private static final int TAG_VALUE_LONG = 4;
    private static final int TAG_VALUE_UINT = 5;
    private static final int TAG_VALUE_SINT = 6;
    private static final int TAG_VALUE_BOOL = 7;
    private static final int TAG_GEOM_UNKNOWN = 0;
    private static final int TAG_GEOM_POINT = 1;
    private static final int TAG_GEOM_LINE = 2;
    private static final int TAG_GEOM_POLYGON = 3;
    private short[] mTmpTags = new short[1024];
    private Tile mTile;
    private final String mLocale = "de";
    private ITileDataSink mMapDataCallback;
    private static final float REF_TILE_SIZE = 4096.0f;
    private float mScale;
    private final Pool<Feature> mFeaturePool = new Pool<Feature>(){
        int count;

        protected Feature createItem() {
            ++this.count;
            return new Feature();
        }

        protected boolean clearItem(Feature item) {
            if (this.count > 100) {
                --this.count;
                return false;
            }
            item.elem.tags.clear();
            item.elem.clear();
            item.tags = null;
            item.type = 0;
            item.numTags = 0;
            return true;
        }
    };
    private static final int CLOSE_PATH = 7;
    private static final int MOVE_TO = 1;
    private int lastX;
    private int lastY;

    public boolean decode(Tile tile, ITileDataSink mapDataCallback, InputStream is) throws IOException {
        int val;
        this.setInputStream(new InflaterInputStream(is));
        this.mTile = tile;
        this.mMapDataCallback = mapDataCallback;
        this.mScale = 4096.0f / (float)Tile.SIZE;
        block3: while (this.hasData() && (val = this.decodeVarint32()) > 0) {
            int tag = val >> 3;
            switch (tag) {
                case 3: {
                    this.decodeLayer();
                    continue block3;
                }
            }
            this.error(this.mTile + " invalid type for tile: " + tag);
            return false;
        }
        if (this.hasData()) {
            this.error(tile + " invalid tile");
            return false;
        }
        return true;
    }

    private boolean decodeLayer() throws IOException {
        int val;
        int bytes = this.decodeVarint32();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String name = null;
        int numFeatures = 0;
        ArrayList<Feature> features = new ArrayList<Feature>();
        int end = this.position() + bytes;
        block8: while (this.position() < end && (val = this.decodeVarint32()) != 0) {
            int tag = val >> 3;
            switch (tag) {
                case 3: {
                    keys.add(this.decodeString());
                    continue block8;
                }
                case 4: {
                    values.add(this.decodeValue());
                    continue block8;
                }
                case 2: {
                    ++numFeatures;
                    this.decodeFeature(features);
                    continue block8;
                }
                case 15: {
                    this.decodeVarint32();
                    continue block8;
                }
                case 1: {
                    name = this.decodeString();
                    continue block8;
                }
                case 5: {
                    this.decodeVarint32();
                    continue block8;
                }
            }
            this.error(this.mTile + " invalid type for layer: " + tag);
        }
        Tag layerTag = new Tag(name, "yes");
        if (numFeatures == 0) {
            return true;
        }
        int[] ignoreLocal = new int[20];
        int numIgnore = 0;
        int fallBackLocal = -1;
        int matchedLocal = -1;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            if (!key.startsWith("name")) continue;
            int len = key.length();
            if (len == 4) {
                fallBackLocal = i;
                continue;
            }
            if (len < 7) {
                ignoreLocal[numIgnore++] = i;
                continue;
            }
            if ("de".equals(key.substring(5))) {
                matchedLocal = i;
                continue;
            }
            ignoreLocal[numIgnore++] = i;
        }
        for (Feature f : features) {
            if (f.elem.type == GeometryBuffer.GeometryType.NONE) continue;
            f.elem.tags.clear();
            f.elem.tags.add(layerTag);
            boolean hasName = false;
            String fallbackName = null;
            block11: for (int j = 0; j < f.numTags << 1; j += 2) {
                short keyIdx = f.tags[j];
                for (int i = 0; i < numIgnore; ++i) {
                    if (keyIdx == ignoreLocal[i]) continue block11;
                }
                if (keyIdx == fallBackLocal) {
                    fallbackName = (String)values.get(f.tags[j + 1]);
                    continue;
                }
                String val2 = (String)values.get(f.tags[j + 1]);
                if (keyIdx == matchedLocal) {
                    hasName = true;
                    f.elem.tags.add(new Tag("name", val2, false));
                    continue;
                }
                String key = (String)keys.get(keyIdx);
                f.elem.tags.add(new Tag(key, val2));
            }
            if (!hasName && fallbackName != null) {
                f.elem.tags.add(new Tag("name", fallbackName, false));
            }
            f.elem.setLayer(5);
            this.mMapDataCallback.process(f.elem);
            f = (Feature)this.mFeaturePool.release((Inlist)f);
        }
        return true;
    }

    private void decodeFeature(ArrayList<Feature> features) throws IOException {
        int val;
        int bytes = this.decodeVarint32();
        int end = this.position() + bytes;
        int type = 0;
        this.lastX = 0;
        this.lastY = 0;
        this.mTmpTags[0] = -1;
        Feature curFeature = null;
        int numTags = 0;
        block6: while (this.position() < end && (val = this.decodeVarint32()) != 0) {
            int tag = val >>> 3;
            switch (tag) {
                case 1: {
                    this.decodeVarint32();
                    continue block6;
                }
                case 2: {
                    this.mTmpTags = this.decodeUnsignedVarintArray(this.mTmpTags);
                    while (numTags < this.mTmpTags.length && this.mTmpTags[numTags] >= 0) {
                        numTags += 2;
                    }
                    numTags >>= 1;
                    continue block6;
                }
                case 3: {
                    type = this.decodeVarint32();
                    continue block6;
                }
                case 4: {
                    for (Feature f : features) {
                        if (!f.match(this.mTmpTags, numTags, type)) continue;
                        curFeature = f;
                        break;
                    }
                    if (curFeature == null) {
                        curFeature = (Feature)this.mFeaturePool.get();
                        curFeature.tags = new short[numTags << 1];
                        System.arraycopy(this.mTmpTags, 0, curFeature.tags, 0, numTags << 1);
                        curFeature.numTags = numTags;
                        curFeature.type = type;
                        features.add(curFeature);
                    }
                    this.decodeCoordinates(type, curFeature);
                    continue block6;
                }
            }
            this.error(this.mTile + " invalid type for feature: " + tag);
        }
    }

    private int decodeCoordinates(int type, Feature feature) throws IOException {
        int bytes = this.decodeVarint32();
        this.fillBuffer(bytes);
        if (feature == null) {
            this.bufferPos += bytes;
            return 0;
        }
        MapElement elem = feature.elem;
        boolean isPoint = false;
        boolean isPoly = false;
        boolean isLine = false;
        if (type == 2) {
            elem.startLine();
            isLine = true;
        } else if (type == 3) {
            elem.startPolygon();
            isPoly = true;
        } else if (type == 1) {
            isPoint = true;
            elem.startPoints();
        } else if (type == 0) {
            elem.startPoints();
        }
        boolean even = true;
        int curX = 0;
        int curY = 0;
        int prevX = 0;
        int prevY = 0;
        int cmd = 0;
        int num = 0;
        int cnt = 0;
        boolean first = true;
        boolean lastClip = false;
        boolean isOuter = true;
        boolean simplify = this.mTile.zoomLevel < 14;
        int pixel = simplify ? 7 : 3;
        int xmin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymin = Integer.MAX_VALUE;
        int ymax = Integer.MIN_VALUE;
        int end = this.bufferPos + bytes;
        while (this.bufferPos < end) {
            int val = this.decodeVarint32Filled();
            if (num == 0) {
                num = val >>> 3;
                cnt = 0;
                cmd = val & 7;
                if (isLine && lastClip) {
                    elem.addPoint((float)curX / this.mScale, (float)curY / this.mScale);
                    lastClip = false;
                }
                if (cmd == 7) {
                    num = 0;
                    continue;
                }
                if (first) {
                    first = false;
                    continue;
                }
                if (cmd != 1) continue;
                if (type == 2) {
                    elem.startLine();
                    continue;
                }
                if (type != 3) continue;
                isOuter = false;
                elem.startHole();
                continue;
            }
            int s = val >>> 1 ^ -(val & 1);
            if (even) {
                even = false;
                curX = this.lastX += s;
                continue;
            }
            even = true;
            curY = this.lastY += s;
            int dx = curX - prevX;
            int dy = curY - prevY;
            if (isPoly && --num == 0 && cnt > 0) {
                prevX = curX;
                prevY = curY;
                int ppos = cnt * 2;
                if (elem.points[elem.pointNextPos - ppos] != (float)curX || elem.points[elem.pointNextPos - ppos + 1] != (float)curY) {
                    elem.addPoint((float)curX / this.mScale, (float)curY / this.mScale);
                }
                lastClip = false;
                continue;
            }
            if (isPoint || cmd == 1 || dx > pixel || dx < -pixel || dy > pixel || dy < -pixel || curX <= 0 || curX >= 4095 || curY <= 0 || curY >= 4095) {
                prevX = curX;
                prevY = curY;
                elem.addPoint((float)curX / this.mScale, (float)curY / this.mScale);
                ++cnt;
                if (simplify && isOuter) {
                    if (curX < xmin) {
                        xmin = curX;
                    }
                    if (curX > xmax) {
                        xmax = curX;
                    }
                    if (curY < ymin) {
                        ymin = curY;
                    }
                    if (curY > ymax) {
                        ymax = curY;
                    }
                }
                lastClip = false;
                continue;
            }
            lastClip = true;
        }
        if (isPoly && isOuter && simplify && !TileDecoder.testBBox(xmax - xmin, ymax - ymin)) {
            elem.pointNextPos -= elem.index[elem.indexCurrentPos];
            if (elem.indexCurrentPos > 0) {
                elem.indexCurrentPos -= 2;
                elem.index[elem.indexCurrentPos + 1] = -1;
            } else {
                elem.type = GeometryBuffer.GeometryType.NONE;
            }
            return 0;
        }
        if (isLine && lastClip) {
            elem.addPoint((float)curX / this.mScale, (float)curY / this.mScale);
        }
        return 1;
    }

    private static boolean testBBox(int dx, int dy) {
        return dx * dy > 4096;
    }

    private String decodeValue() throws IOException {
        int val;
        int bytes = this.decodeVarint32();
        String value = null;
        int end = this.position() + bytes;
        while (this.position() < end && (val = this.decodeVarint32()) != 0) {
            int tag = val >> 3;
            switch (tag) {
                case 1: {
                    value = this.decodeString();
                    break;
                }
                case 5: {
                    value = String.valueOf(this.decodeVarint32());
                    break;
                }
                case 6: {
                    value = String.valueOf(TileDecoder.deZigZag((int)this.decodeVarint32()));
                    break;
                }
                case 4: {
                    value = String.valueOf(this.decodeVarint64());
                    break;
                }
                case 2: {
                    value = String.valueOf(this.decodeFloat());
                    break;
                }
                case 3: {
                    value = String.valueOf(this.decodeDouble());
                    break;
                }
                case 7: {
                    value = this.decodeBool() ? "yes" : "no";
                    break;
                }
            }
        }
        return value;
    }

    static class Feature
    extends Inlist<Feature> {
        short[] tags;
        int numTags;
        int type;
        final MapElement elem = new MapElement();

        Feature() {
        }

        boolean match(short[] otherTags, int otherNumTags, int otherType) {
            if (this.numTags != otherNumTags) {
                return false;
            }
            if (this.type != otherType) {
                return false;
            }
            for (int i = 0; i < this.numTags << 1; ++i) {
                if (this.tags[i] == otherTags[i]) continue;
                return false;
            }
            return true;
        }
    }
}

