/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.geojson;

import java.util.HashMap;
import java.util.Map;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.source.ITileDecoder;
import org.oscim.tiling.source.UrlTileDataSource;
import org.oscim.tiling.source.UrlTileSource;
import org.oscim.tiling.source.geojson.GeoJsonTileDecoder;

public abstract class GeoJsonTileSource
extends UrlTileSource {
    public GeoJsonTileSource(String url) {
        super(url, "/{Z}/{X}/{Y}.json");
        HashMap<String, String> opt = new HashMap<String, String>();
        opt.put("Accept-Encoding", "gzip");
        this.setHttpRequestHeaders(opt);
    }

    public GeoJsonTileSource(String url, int zoomMin, int zoomMax) {
        super(url, "/{Z}/{X}/{Y}.json", zoomMin, zoomMax);
        HashMap<String, String> opt = new HashMap<String, String>();
        opt.put("Accept-Encoding", "gzip");
        this.setHttpRequestHeaders(opt);
    }

    public ITileDataSource getDataSource() {
        return new UrlTileDataSource((UrlTileSource)this, (ITileDecoder)new GeoJsonTileDecoder(this), this.getHttpEngine());
    }

    public Tag getFeatureTag() {
        return null;
    }

    public abstract void decodeTags(MapElement var1, Map<String, Object> var2);

    public Tag rewriteTag(String key, Object value) {
        if (value == null) {
            return null;
        }
        String val = value instanceof String ? (String)value : String.valueOf(value);
        return new Tag(key, val);
    }

    public void postGeomHook(MapElement mapElement) {
    }
}

