/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.overpass;

import java.io.IOException;
import java.io.InputStream;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.core.Tile;
import org.oscim.core.osm.OsmData;
import org.oscim.core.osm.OsmElement;
import org.oscim.core.osm.OsmNode;
import org.oscim.core.osm.OsmRelation;
import org.oscim.core.osm.OsmWay;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.source.ITileDecoder;
import org.oscim.tiling.source.mapfile.OSMUtils;
import org.oscim.utils.overpass.OverpassAPIReader;

public class TileDecoder
implements ITileDecoder {
    private final MapElement mMapElement = new MapElement();
    private ITileDataSink mTileDataSink;
    private double mTileY;
    private double mTileX;
    private double mTileScale;

    public TileDecoder() {
        this.mMapElement.layer = 5;
    }

    public synchronized boolean decode(Tile tile, ITileDataSink sink, InputStream is) {
        OsmData data;
        this.mTileDataSink = sink;
        this.mTileScale = 1 << tile.zoomLevel;
        this.mTileX = (double)tile.tileX / this.mTileScale;
        this.mTileY = (double)tile.tileY / this.mTileScale;
        this.mTileScale *= (double)Tile.SIZE;
        try {
            OverpassAPIReader reader = new OverpassAPIReader();
            reader.parse(is);
            data = reader.getData();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        for (OsmNode osmNode : data.getNodes()) {
            this.parseFeature(osmNode);
        }
        for (OsmWay osmWay : data.getWays()) {
            this.parseFeature(osmWay);
        }
        for (OsmRelation osmRelation : data.getRelations()) {
            this.parseFeature(osmRelation);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void parseFeature(OsmElement element) {
        if (element.tags == null || element.tags.size() == 0) {
            return;
        }
        MapElement mapElement = this.mMapElement;
        synchronized (mapElement) {
            this.mMapElement.clear();
            this.mMapElement.tags.clear();
            this.mMapElement.tags.set(element.tags);
            this.decodeTags(this.mMapElement);
            this.parseGeometry(element);
            if (this.mMapElement.type == GeometryBuffer.GeometryType.NONE) {
                return;
            }
            this.mTileDataSink.process(this.mMapElement);
        }
    }

    private void parseGeometry(OsmElement element) {
        if (element instanceof OsmWay) {
            boolean linearFeature;
            boolean bl = linearFeature = !OSMUtils.isArea((MapElement)this.mMapElement);
            if (linearFeature) {
                this.mMapElement.type = GeometryBuffer.GeometryType.LINE;
                this.parseLine((OsmWay)element);
            } else {
                this.mMapElement.type = GeometryBuffer.GeometryType.POLY;
                this.parsePolygon((OsmWay)element);
            }
        } else if (element instanceof OsmNode) {
            this.mMapElement.type = GeometryBuffer.GeometryType.POINT;
            this.mMapElement.startPoints();
            this.parseCoordinate((OsmNode)element);
        }
    }

    private void parsePolygon(OsmWay element) {
        this.mMapElement.startPolygon();
        this.parseCoordSequence(element);
        this.mMapElement.removeLastPoint();
    }

    private void parseLine(OsmWay element) {
        this.mMapElement.startLine();
        this.parseCoordSequence(element);
    }

    private void parseCoordSequence(OsmWay element) {
        for (OsmNode node : element.nodes) {
            this.parseCoordinate(node);
        }
    }

    private void parseCoordinate(OsmNode element) {
        this.mMapElement.addPoint((float)((MercatorProjection.longitudeToX((double)element.lon) - this.mTileX) * this.mTileScale), (float)((MercatorProjection.latitudeToY((double)element.lat) - this.mTileY) * this.mTileScale));
    }

    private void decodeTags(MapElement mapElement) {
        TagSet tags = mapElement.tags;
        Tag tag = tags.get("roof:direction");
        if (tag != null && !TileDecoder.isNumeric(tag.value)) {
            switch (tag.value.toLowerCase()) {
                case "n": 
                case "north": {
                    tag.value = "0";
                    break;
                }
                case "e": 
                case "east": {
                    tag.value = "90";
                    break;
                }
                case "s": 
                case "south": {
                    tag.value = "180";
                    break;
                }
                case "w": 
                case "west": {
                    tag.value = "270";
                    break;
                }
                case "ne": {
                    tag.value = "45";
                    break;
                }
                case "se": {
                    tag.value = "135";
                    break;
                }
                case "sw": {
                    tag.value = "225";
                    break;
                }
                case "nw": {
                    tag.value = "315";
                    break;
                }
                case "nne": {
                    tag.value = "22";
                    break;
                }
                case "ene": {
                    tag.value = "67";
                    break;
                }
                case "ese": {
                    tag.value = "112";
                    break;
                }
                case "sse": {
                    tag.value = "157";
                    break;
                }
                case "ssw": {
                    tag.value = "202";
                    break;
                }
                case "wsw": {
                    tag.value = "247";
                    break;
                }
                case "wnw": {
                    tag.value = "292";
                    break;
                }
                case "nnw": {
                    tag.value = "337";
                    break;
                }
                default: {
                    tag.value = "0";
                }
            }
        }
    }

    private static boolean isNumeric(String str) {
        try {
            Float.parseFloat(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

