/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.geojson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.source.ITileDecoder;
import org.oscim.tiling.source.geojson.GeoJsonTileSource;
import org.oscim.utils.ArrayUtils;

public class GeoJsonTileDecoder
implements ITileDecoder {
    private final MapElement mMapElement;
    private final GeoJsonTileSource mTileSource;
    private final LinkedHashMap<String, Object> mTagMap;
    private final JsonFactory mJsonFactory;
    private static final char[] FIELD_FEATURES = "features".toCharArray();
    private static final char[] FIELD_GEOMETRY = "geometry".toCharArray();
    private static final char[] FIELD_PROPERTIES = "properties".toCharArray();
    private static final char[] FIELD_COORDINATES = "coordinates".toCharArray();
    private static final char[] FIELD_TYPE = "type".toCharArray();
    private static final char[] LINETRING = "LineString".toCharArray();
    private static final char[] POLYGON = "Polygon".toCharArray();
    private static final char[] POINT = "Point".toCharArray();
    private static final char[] MULTI_LINESTRING = "MultiLineString".toCharArray();
    private static final char[] MULTI_POLYGON = "MultiPolygon".toCharArray();
    private static final char[] MULTI_POINT = "MultiPoint".toCharArray();
    private ITileDataSink mTileDataSink;
    private double mTileY;
    private double mTileX;
    private double mTileScale;

    public GeoJsonTileDecoder(GeoJsonTileSource tileSource) {
        this.mTileSource = tileSource;
        this.mTagMap = new LinkedHashMap();
        this.mJsonFactory = new JsonFactory();
        this.mMapElement = new MapElement();
        this.mMapElement.layer = 5;
    }

    public boolean decode(Tile tile, ITileDataSink sink, InputStream is) throws IOException {
        JsonToken t;
        this.mTileDataSink = sink;
        this.mTileScale = 1 << tile.zoomLevel;
        this.mTileX = (double)tile.tileX / this.mTileScale;
        this.mTileY = (double)tile.tileY / this.mTileScale;
        this.mTileScale *= (double)Tile.SIZE;
        JsonParser jp = this.mJsonFactory.createParser((Reader)new InputStreamReader(is));
        block0: while ((t = jp.nextToken()) != null) {
            if (t != JsonToken.FIELD_NAME || !GeoJsonTileDecoder.match(jp, FIELD_FEATURES) || jp.nextToken() != JsonToken.START_ARRAY) continue;
            while ((t = jp.nextToken()) != null) {
                if (t == JsonToken.START_OBJECT) {
                    this.parseFeature(jp);
                }
                if (t != JsonToken.END_ARRAY) continue;
                continue block0;
            }
        }
        return true;
    }

    private void parseFeature(JsonParser jp) throws JsonParseException, IOException {
        JsonToken t;
        this.mMapElement.clear();
        this.mMapElement.tags.clear();
        this.mTagMap.clear();
        while ((t = jp.nextToken()) != null) {
            if (t == JsonToken.FIELD_NAME) {
                if (GeoJsonTileDecoder.match(jp, FIELD_GEOMETRY) && jp.nextToken() == JsonToken.START_OBJECT) {
                    this.parseGeometry(jp);
                }
                if (!GeoJsonTileDecoder.match(jp, FIELD_PROPERTIES) || jp.nextToken() != JsonToken.START_OBJECT) continue;
                this.parseProperties(jp);
                continue;
            }
            if (t != JsonToken.END_OBJECT) continue;
        }
        this.mTileSource.decodeTags(this.mMapElement, this.mTagMap);
        if (this.mMapElement.tags.size() == 0) {
            return;
        }
        this.mTileSource.postGeomHook(this.mMapElement);
        if (this.mMapElement.type == GeometryBuffer.GeometryType.NONE) {
            return;
        }
        this.mTileDataSink.process(this.mMapElement);
    }

    private void parseProperties(JsonParser jp) throws JsonParseException, IOException {
        JsonToken t;
        while ((t = jp.nextToken()) != null) {
            if (t == JsonToken.FIELD_NAME) {
                String text = jp.getCurrentName();
                t = jp.nextToken();
                if (t == JsonToken.VALUE_STRING) {
                    this.mTagMap.put(text, jp.getText());
                    continue;
                }
                if (t != JsonToken.VALUE_NUMBER_INT) continue;
                this.mTagMap.put(text, jp.getNumberValue());
                continue;
            }
            if (t != JsonToken.END_OBJECT) continue;
            break;
        }
    }

    private void parseGeometry(JsonParser jp) throws JsonParseException, IOException {
        JsonToken t;
        boolean multi = false;
        GeometryBuffer.GeometryType type = GeometryBuffer.GeometryType.NONE;
        while ((t = jp.nextToken()) != null) {
            if (t == JsonToken.FIELD_NAME) {
                if (GeoJsonTileDecoder.match(jp, FIELD_COORDINATES)) {
                    if (jp.nextToken() != JsonToken.START_ARRAY) continue;
                    if (multi) {
                        this.parseMulti(jp, type);
                        continue;
                    }
                    if (type == GeometryBuffer.GeometryType.POLY) {
                        this.parsePolygon(jp);
                    }
                    if (type == GeometryBuffer.GeometryType.LINE) {
                        this.parseLineString(jp);
                    }
                    if (type != GeometryBuffer.GeometryType.POINT) continue;
                    this.parseCoordinate(jp);
                    continue;
                }
                if (!GeoJsonTileDecoder.match(jp, FIELD_TYPE)) continue;
                multi = false;
                jp.nextToken();
                if (GeoJsonTileDecoder.match(jp, LINETRING)) {
                    type = GeometryBuffer.GeometryType.LINE;
                } else if (GeoJsonTileDecoder.match(jp, POLYGON)) {
                    type = GeometryBuffer.GeometryType.POLY;
                } else if (GeoJsonTileDecoder.match(jp, POINT)) {
                    type = GeometryBuffer.GeometryType.POINT;
                } else if (GeoJsonTileDecoder.match(jp, MULTI_LINESTRING)) {
                    type = GeometryBuffer.GeometryType.LINE;
                    multi = true;
                } else if (GeoJsonTileDecoder.match(jp, MULTI_POLYGON)) {
                    type = GeometryBuffer.GeometryType.POLY;
                    multi = true;
                } else if (GeoJsonTileDecoder.match(jp, MULTI_POINT)) {
                    type = GeometryBuffer.GeometryType.POINT;
                    multi = true;
                }
                if (type != GeometryBuffer.GeometryType.POINT) continue;
                this.mMapElement.startPoints();
                continue;
            }
            if (t != JsonToken.END_OBJECT) continue;
            break;
        }
    }

    private void parseMulti(JsonParser jp, GeometryBuffer.GeometryType type) throws JsonParseException, IOException {
        JsonToken t;
        while ((t = jp.nextToken()) != null && t != JsonToken.END_ARRAY) {
            if (t != JsonToken.START_ARRAY) continue;
            if (type == GeometryBuffer.GeometryType.POLY) {
                this.parsePolygon(jp);
                continue;
            }
            if (type == GeometryBuffer.GeometryType.LINE) {
                this.parseLineString(jp);
                continue;
            }
            if (type != GeometryBuffer.GeometryType.POINT) continue;
            this.parseCoordinate(jp);
        }
    }

    private void parsePolygon(JsonParser jp) throws JsonParseException, IOException {
        JsonToken t;
        int ring = 0;
        while ((t = jp.nextToken()) != null) {
            if (t == JsonToken.START_ARRAY) {
                if (ring == 0) {
                    this.mMapElement.startPolygon();
                } else {
                    this.mMapElement.startHole();
                }
                ++ring;
                this.parseCoordSequence(jp);
                this.mMapElement.removeLastPoint();
                continue;
            }
            if (t != JsonToken.END_ARRAY) continue;
            break;
        }
    }

    private void parseLineString(JsonParser jp) throws JsonParseException, IOException {
        this.mMapElement.startLine();
        this.parseCoordSequence(jp);
    }

    private void parseCoordSequence(JsonParser jp) throws JsonParseException, IOException {
        JsonToken t;
        while ((t = jp.nextToken()) != null) {
            if (t == JsonToken.START_ARRAY) {
                this.parseCoordinate(jp);
                continue;
            }
            if (t != JsonToken.END_ARRAY) continue;
            break;
        }
    }

    private void parseCoordinate(JsonParser jp) throws JsonParseException, IOException {
        JsonToken t;
        int pos = 0;
        double x = 0.0;
        double y = 0.0;
        while ((t = jp.nextToken()) != null) {
            if (t == JsonToken.VALUE_NUMBER_FLOAT || t == JsonToken.VALUE_NUMBER_INT) {
                char[] val = jp.getTextCharacters();
                int offset = jp.getTextOffset();
                int length = jp.getTextLength();
                double c = ArrayUtils.parseNumber((char[])val, (int)offset, (int)(offset + length));
                if (pos == 0) {
                    x = c;
                }
                if (pos == 1) {
                    y = c;
                }
                ++pos;
                continue;
            }
            if (t != JsonToken.END_ARRAY) continue;
        }
        this.mMapElement.addPoint((float)((MercatorProjection.longitudeToX((double)x) - this.mTileX) * this.mTileScale), (float)((MercatorProjection.latitudeToY((double)y) - this.mTileY) * this.mTileScale));
    }

    private static final boolean match(JsonParser jp, char[] fieldName) throws JsonParseException, IOException {
        int length = jp.getTextLength();
        if (length != fieldName.length) {
            return false;
        }
        char[] val = jp.getTextCharacters();
        int offset = jp.getTextOffset();
        for (int i = 0; i < length; ++i) {
            if (fieldName[i] == val[i + offset]) continue;
            return false;
        }
        return true;
    }
}

