/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.geojson;

import java.util.LinkedHashMap;
import java.util.Map;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.tiling.source.geojson.GeoJsonTileSource;

public class OsmLanduseJsonTileSource
extends GeoJsonTileSource {
    private static LinkedHashMap<String, Tag> mappings = new LinkedHashMap();
    private static final Tag mTagArea;

    public OsmLanduseJsonTileSource() {
        super("http://tile.openstreetmap.us/vectiles-land-usages");
    }

    static void addMapping(String key, String val) {
        mappings.put(val, new Tag(key, val));
    }

    @Override
    public void decodeTags(MapElement mapElement, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (!"kind".equals(key)) continue;
            String value = (String)entry.getValue();
            Tag tag = mappings.get(value);
            if (tag == null) {
                System.out.println("unmatched " + value);
                break;
            }
            mapElement.tags.add(tag);
            break;
        }
    }

    @Override
    public void postGeomHook(MapElement mapElement) {
        mapElement.type = GeometryBuffer.GeometryType.POLY;
        mapElement.tags.add(mTagArea);
    }

    static {
        OsmLanduseJsonTileSource.addMapping("landuse", "residential");
        OsmLanduseJsonTileSource.addMapping("landuse", "commercial");
        OsmLanduseJsonTileSource.addMapping("landuse", "retail");
        OsmLanduseJsonTileSource.addMapping("landuse", "railway");
        OsmLanduseJsonTileSource.addMapping("landuse", "grass");
        OsmLanduseJsonTileSource.addMapping("landuse", "meadow");
        OsmLanduseJsonTileSource.addMapping("landuse", "forest");
        OsmLanduseJsonTileSource.addMapping("landuse", "farm");
        OsmLanduseJsonTileSource.addMapping("landuse", "allotments");
        OsmLanduseJsonTileSource.addMapping("landuse", "cemetery");
        OsmLanduseJsonTileSource.addMapping("landuse", "farmyard");
        OsmLanduseJsonTileSource.addMapping("landuse", "farmland");
        OsmLanduseJsonTileSource.addMapping("landuse", "quarry");
        OsmLanduseJsonTileSource.addMapping("landuse", "military");
        OsmLanduseJsonTileSource.addMapping("landuse", "industrial");
        OsmLanduseJsonTileSource.addMapping("landuse", "greenfield");
        OsmLanduseJsonTileSource.addMapping("landuse", "village_green");
        OsmLanduseJsonTileSource.addMapping("landuse", "recreation_ground");
        OsmLanduseJsonTileSource.addMapping("landuse", "conservation");
        OsmLanduseJsonTileSource.addMapping("landuse", "landfill");
        OsmLanduseJsonTileSource.addMapping("landuse", "construction");
        OsmLanduseJsonTileSource.addMapping("leisure", "common");
        OsmLanduseJsonTileSource.addMapping("leisure", "park");
        OsmLanduseJsonTileSource.addMapping("leisure", "pitch");
        OsmLanduseJsonTileSource.addMapping("leisure", "garden");
        OsmLanduseJsonTileSource.addMapping("leisure", "sports_centre");
        OsmLanduseJsonTileSource.addMapping("leisure", "playground");
        OsmLanduseJsonTileSource.addMapping("leisure", "nature_reserve");
        OsmLanduseJsonTileSource.addMapping("leisure", "golf_course");
        OsmLanduseJsonTileSource.addMapping("leisure", "stadium");
        OsmLanduseJsonTileSource.addMapping("amenity", "hospital");
        OsmLanduseJsonTileSource.addMapping("amenity", "cinema");
        OsmLanduseJsonTileSource.addMapping("amenity", "school");
        OsmLanduseJsonTileSource.addMapping("amenity", "college");
        OsmLanduseJsonTileSource.addMapping("amenity", "university");
        OsmLanduseJsonTileSource.addMapping("amenity", "theatre");
        OsmLanduseJsonTileSource.addMapping("amenity", "library");
        OsmLanduseJsonTileSource.addMapping("amenity", "parking");
        OsmLanduseJsonTileSource.addMapping("amenity", "place_of_worship");
        OsmLanduseJsonTileSource.addMapping("highway", "pedestrian");
        OsmLanduseJsonTileSource.addMapping("highway", "footway");
        OsmLanduseJsonTileSource.addMapping("highway", "service");
        OsmLanduseJsonTileSource.addMapping("highway", "street");
        OsmLanduseJsonTileSource.addMapping("natural", "scrub");
        OsmLanduseJsonTileSource.addMapping("natural", "wood");
        mappings.put("urban area", new Tag("landuse", "urban"));
        mappings.put("park or protected land", new Tag("leisure", "park"));
        mTagArea = new Tag("area", "yes");
    }
}

