/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.geojson;

import java.util.Map;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.tiling.source.geojson.GeoJsonTileSource;

public class OsmRoadLabelJsonTileSource
extends GeoJsonTileSource {
    public OsmRoadLabelJsonTileSource() {
        super("http://tile.openstreetmap.us/vectiles-skeletron");
    }

    @Override
    public void decodeTags(MapElement mapElement, Map<String, Object> properties) {
        String highway = null;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if ("highway".equals(key) && value instanceof String) {
                highway = (String)entry.getValue();
                continue;
            }
            if (!"name".equals(key) || !(value instanceof String)) continue;
            mapElement.tags.add(new Tag("name", (String)value));
        }
        if (highway == null) {
            return;
        }
        mapElement.tags.add(new Tag("highway", highway));
    }
}

