/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.oscimap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.source.PbfDecoder;
import org.oscim.tiling.source.oscimap.Tags;

public class TileDecoder
extends PbfDecoder {
    private static final Logger log = Logger.getLogger(TileDecoder.class.getName());
    private static final float REF_TILE_SIZE = 4096.0f;
    private static final int TAG_TILE_TAGS = 1;
    private static final int TAG_TILE_WAYS = 2;
    private static final int TAG_TILE_POLY = 3;
    private static final int TAG_TILE_NODES = 4;
    private static final int TAG_WAY_TAGS = 11;
    private static final int TAG_WAY_INDEX = 12;
    private static final int TAG_WAY_COORDS = 13;
    private static final int TAG_WAY_LAYER = 21;
    private static final int TAG_WAY_NUM_TAGS = 1;
    private static final int TAG_WAY_NUM_INDICES = 2;
    private static final int TAG_WAY_NUM_COORDS = 3;
    private static final int TAG_NODE_TAGS = 11;
    private static final int TAG_NODE_COORDS = 12;
    private static final int TAG_NODE_LAYER = 21;
    private static final int TAG_NODE_NUM_TAGS = 1;
    private static final int TAG_NODE_NUM_COORDS = 2;
    private int MAX_TILE_TAGS = 100;
    private Tag[] curTags = new Tag[this.MAX_TILE_TAGS];
    private int mCurTagCnt;
    private ITileDataSink mSink;
    private float mScale;
    private Tile mTile;
    private final MapElement mElem = new MapElement();
    private static final int MAX_TAGS_CACHE = 100;
    private static Map<String, Tag> tagHash = Collections.synchronizedMap(new LinkedHashMap<String, Tag>(100, 0.75f, true){
        private static final long serialVersionUID = 1L;
    });

    TileDecoder() {
    }

    public boolean decode(Tile tile, ITileDataSink sink, InputStream is) throws IOException {
        this.setInputStream(is);
        this.mTile = tile;
        this.mSink = sink;
        this.mScale = 4096.0f / (float)Tile.SIZE;
        return this.decode();
    }

    private boolean decode() throws IOException {
        int val;
        this.mCurTagCnt = 0;
        block6: while (this.hasData() && (val = this.decodeVarint32()) > 0) {
            int tag = val >> 3;
            switch (tag) {
                case 1: {
                    this.decodeTileTags();
                    continue block6;
                }
                case 2: {
                    this.decodeTileWays(false);
                    continue block6;
                }
                case 3: {
                    this.decodeTileWays(true);
                    continue block6;
                }
                case 4: {
                    this.decodeTileNodes();
                    continue block6;
                }
            }
            log.fine("invalid type for tile: " + tag);
            return false;
        }
        return true;
    }

    private boolean decodeTileTags() throws IOException {
        String tagString = this.decodeString();
        if (tagString == null || tagString.length() == 0) {
            this.curTags[this.mCurTagCnt++] = new Tag("name", "...");
            return false;
        }
        Tag tag = tagHash.get(tagString);
        if (tag == null && (tag = tagString.startsWith("name") ? new Tag("name", tagString.substring(5), false) : Tag.parse((String)tagString)) != null) {
            tagHash.put(tagString, tag);
        }
        if (this.mCurTagCnt >= this.MAX_TILE_TAGS) {
            this.MAX_TILE_TAGS = this.mCurTagCnt + 10;
            Tag[] tmp = new Tag[this.MAX_TILE_TAGS];
            System.arraycopy(this.curTags, 0, tmp, 0, this.mCurTagCnt);
            this.curTags = tmp;
        }
        this.curTags[this.mCurTagCnt++] = tag;
        return true;
    }

    private boolean decodeTileWays(boolean polygon) throws IOException {
        int val;
        int bytes = this.decodeVarint32();
        int end = this.position() + bytes;
        int indexCnt = 0;
        int tagCnt = 0;
        int coordCnt = 0;
        int layer = 5;
        boolean fail = false;
        block9: while (this.position() < end && (val = this.decodeVarint32()) != 0) {
            int tag = val >> 3;
            switch (tag) {
                case 11: {
                    if (this.decodeWayTags(tagCnt)) continue block9;
                    return false;
                }
                case 12: {
                    this.decodeWayIndices(indexCnt);
                    continue block9;
                }
                case 13: {
                    if (coordCnt == 0) {
                        log.fine(this.mTile + " no coordinates");
                    }
                    this.mElem.ensurePointSize(coordCnt, false);
                    int cnt = this.decodeInterleavedPoints(this.mElem.points, this.mScale);
                    if (cnt == coordCnt) continue block9;
                    log.fine(this.mTile + " wrong number of coordinates " + coordCnt + "/" + cnt);
                    fail = true;
                    continue block9;
                }
                case 21: {
                    layer = this.decodeVarint32();
                    continue block9;
                }
                case 1: {
                    tagCnt = this.decodeVarint32();
                    continue block9;
                }
                case 2: {
                    indexCnt = this.decodeVarint32();
                    continue block9;
                }
                case 3: {
                    coordCnt = this.decodeVarint32();
                    continue block9;
                }
            }
            log.fine("X invalid type for way: " + tag);
        }
        if (fail || indexCnt == 0 || tagCnt == 0) {
            log.fine("failed reading way: bytes:" + bytes + " index:" + indexCnt + " " + coordCnt + " " + tagCnt);
            return false;
        }
        this.mElem.type = polygon ? GeometryBuffer.GeometryType.POLY : GeometryBuffer.GeometryType.LINE;
        this.mElem.setLayer(layer);
        this.mSink.process(this.mElem);
        return true;
    }

    private boolean decodeTileNodes() throws IOException {
        int val;
        int bytes = this.decodeVarint32();
        int end = this.position() + bytes;
        int tagCnt = 0;
        int coordCnt = 0;
        byte layer = 0;
        block7: while (this.position() < end && (val = this.decodeVarint32()) != 0) {
            int tag = val >> 3;
            switch (tag) {
                case 11: {
                    if (this.decodeWayTags(tagCnt)) continue block7;
                    return false;
                }
                case 12: {
                    int cnt = this.decodeNodeCoordinates(coordCnt, layer);
                    if (cnt == coordCnt) continue block7;
                    log.fine("X wrong number of coordinates");
                    return false;
                }
                case 21: {
                    layer = (byte)this.decodeVarint32();
                    continue block7;
                }
                case 1: {
                    tagCnt = this.decodeVarint32();
                    continue block7;
                }
                case 2: {
                    coordCnt = this.decodeVarint32();
                    continue block7;
                }
            }
            log.fine("X invalid type for node: " + tag);
        }
        return true;
    }

    private int decodeNodeCoordinates(int numNodes, byte layer) throws IOException {
        int bytes = this.decodeVarint32();
        this.fillBuffer(bytes);
        int cnt = 0;
        int end = this.position() + bytes;
        int lastX = 0;
        int lastY = 0;
        float[] coords = this.mElem.ensurePointSize(numNodes, false);
        while (this.position() < end && cnt < numNodes) {
            int lon = TileDecoder.deZigZag((int)this.decodeVarint32());
            int lat = TileDecoder.deZigZag((int)this.decodeVarint32());
            lastX = lon + lastX;
            lastY = lat + lastY;
            coords[cnt++] = (float)lastX / this.mScale;
            coords[cnt++] = (float)Tile.SIZE - (float)lastY / this.mScale;
        }
        this.mElem.index[0] = (short)numNodes;
        this.mElem.type = GeometryBuffer.GeometryType.POINT;
        this.mElem.setLayer((int)layer);
        this.mSink.process(this.mElem);
        return cnt;
    }

    private boolean decodeWayTags(int tagCnt) throws IOException {
        int bytes = this.decodeVarint32();
        this.mElem.tags.clear();
        int cnt = 0;
        int end = this.position() + bytes;
        int max = this.mCurTagCnt;
        while (this.position() < end) {
            int tagNum = this.decodeVarint32();
            if (tagNum < 0 || cnt == tagCnt) {
                log.fine("NULL TAG: " + this.mTile + " invalid tag:" + tagNum + " " + tagCnt + "/" + cnt);
            } else if (tagNum < 654) {
                this.mElem.tags.add(Tags.tags[tagNum]);
            } else if ((tagNum -= 1024) >= 0 && tagNum < max) {
                this.mElem.tags.add(this.curTags[tagNum]);
            } else {
                log.fine("NULL TAG: " + this.mTile + " could find tag:" + tagNum + " " + tagCnt + "/" + cnt);
            }
            ++cnt;
        }
        if (tagCnt != cnt) {
            log.fine("NULL TAG: " + this.mTile);
            return false;
        }
        return true;
    }

    private int decodeWayIndices(int indexCnt) throws IOException {
        this.mElem.ensureIndexSize(indexCnt, false);
        this.decodeVarintArray(indexCnt, this.mElem.index);
        int[] index = this.mElem.index;
        int coordCnt = 0;
        int i = 0;
        while (i < indexCnt) {
            coordCnt += index[i];
            int n = i++;
            index[n] = index[n] * 2;
        }
        if (indexCnt < index.length) {
            index[indexCnt] = -1;
        }
        return coordCnt;
    }

    protected int decodeInterleavedPoints(float[] coords, float scale) throws IOException {
        int bytes = this.decodeVarint32();
        this.fillBuffer(bytes);
        int cnt = 0;
        int lastX = 0;
        int lastY = 0;
        boolean even = true;
        byte[] buf = this.buffer;
        int pos = this.bufferPos;
        int end = pos + bytes;
        while (pos < end) {
            int val;
            if (buf[pos] >= 0) {
                val = buf[pos++];
            } else if (buf[pos + 1] >= 0) {
                val = buf[pos++] & 0x7F | buf[pos++] << 7;
            } else if (buf[pos + 2] >= 0) {
                val = buf[pos++] & 0x7F | (buf[pos++] & 0x7F) << 7 | buf[pos++] << 14;
            } else if (buf[pos + 3] >= 0) {
                val = buf[pos++] & 0x7F | (buf[pos++] & 0x7F) << 7 | (buf[pos++] & 0x7F) << 14 | buf[pos++] << 21;
            } else {
                val = buf[pos++] & 0x7F | (buf[pos++] & 0x7F) << 7 | (buf[pos++] & 0x7F) << 14 | (buf[pos++] & 0x7F) << 21 | buf[pos] << 28;
                if (buf[pos++] < 0) {
                    throw INVALID_VARINT;
                }
            }
            int s = val >>> 1 ^ -(val & 1);
            if (even) {
                coords[cnt++] = (float)(lastX += s) / scale;
                even = false;
                continue;
            }
            coords[cnt++] = (float)Tile.SIZE - (float)(lastY += s) / scale;
            even = true;
        }
        if (pos != this.bufferPos + bytes) {
            throw INVALID_PACKED_SIZE;
        }
        this.bufferPos = pos;
        return cnt;
    }
}

