/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.oscimap2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Logger;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.source.ITileDecoder;
import org.oscim.tiling.source.PbfDecoder;
import org.oscim.tiling.source.UrlTileDataSource;
import org.oscim.tiling.source.UrlTileSource;
import org.oscim.tiling.source.oscimap2.Tags;

public class OSciMap2TileSource
extends UrlTileSource {
    public OSciMap2TileSource(String url) {
        super(url, "/{Z}/{X}/{Y}.osmtile");
    }

    public ITileDataSource getDataSource() {
        return new UrlTileDataSource((UrlTileSource)this, (ITileDecoder)new TileDecoder(), this.getHttpEngine());
    }

    static class TileDecoder
    extends PbfDecoder {
        private static final Logger log = Logger.getLogger(TileDecoder.class.getName());
        private static final int TAG_TILE_NUM_TAGS = 1;
        private static final int TAG_TILE_TAG_KEYS = 2;
        private static final int TAG_TILE_TAG_VALUES = 3;
        private static final int TAG_TILE_LINE = 11;
        private static final int TAG_TILE_POLY = 12;
        private static final int TAG_TILE_POINT = 13;
        private static final int TAG_ELEM_NUM_INDICES = 1;
        private static final int TAG_ELEM_TAGS = 11;
        private static final int TAG_ELEM_INDEX = 12;
        private static final int TAG_ELEM_COORDS = 13;
        private static final int TAG_ELEM_LAYER = 21;
        private static final int TAG_ELEM_HEIGHT = 31;
        private static final int TAG_ELEM_MIN_HEIGHT = 32;
        private static final int TAG_ELEM_PRIORITY = 41;
        private int[] mSArray;
        private final TagSet mTileTags;
        private final MapElement mElem = new MapElement();
        private Tile mTile;
        private ITileDataSink mMapDataSink;
        private static final float REF_TILE_SIZE = 4096.0f;
        private float mScale;

        TileDecoder() {
            this.mTileTags = new TagSet(20);
            this.mSArray = new int[100];
        }

        public boolean decode(Tile tile, ITileDataSink sink, InputStream is) throws IOException {
            int val;
            TileDecoder.readUnsignedInt((InputStream)is, (byte[])this.buffer);
            this.setInputStream(is);
            this.mTile = tile;
            this.mMapDataSink = sink;
            this.mScale = 4096.0f / (float)Tile.SIZE;
            this.mTileTags.clear();
            int numTags = 0;
            block6: while (this.hasData() && (val = this.decodeVarint32()) > 0) {
                int tag = val >> 3;
                switch (tag) {
                    case 1: {
                        numTags = this.decodeVarint32();
                        continue block6;
                    }
                    case 2: {
                        int len = numTags;
                        if (this.mSArray.length < len) {
                            this.mSArray = new int[len];
                        }
                        this.decodeVarintArray(numTags, this.mSArray);
                        continue block6;
                    }
                    case 3: {
                        this.decodeTileTags();
                        continue block6;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        this.decodeTileElement(tag);
                        continue block6;
                    }
                }
                log.fine(this.mTile + " invalid type for tile: " + tag);
                return false;
            }
            return true;
        }

        private boolean decodeTileTags() throws IOException {
            String tagString = this.decodeString();
            int curTag = this.mTileTags.size();
            String key = Tags.keys[this.mSArray[curTag]];
            Tag tag = "name".equals(key) ? new Tag(key, tagString, false) : new Tag(key, tagString, true);
            this.mTileTags.add(tag);
            return true;
        }

        private int decodeWayIndices(int indexCnt) throws IOException {
            this.mElem.ensureIndexSize(indexCnt, false);
            this.decodeVarintArray(indexCnt, this.mElem.index);
            int[] index = this.mElem.index;
            int coordCnt = 0;
            int i = 0;
            while (i < indexCnt) {
                coordCnt += index[i];
                int n = i++;
                index[n] = index[n] * 2;
            }
            if (indexCnt < index.length) {
                index[indexCnt] = -1;
            }
            return coordCnt;
        }

        private boolean decodeTileElement(int type) throws IOException {
            int val;
            int bytes = this.decodeVarint32();
            short[] index = null;
            int end = this.position() + bytes;
            int indexCnt = 1;
            boolean fail = false;
            int coordCnt = 0;
            if (type == 13) {
                coordCnt = 1;
                this.mElem.index[0] = 2;
            }
            this.mElem.layer = 5;
            block15: while (this.position() < end && (val = this.decodeVarint32()) != 0) {
                int tag = val >> 3;
                switch (tag) {
                    case 11: {
                        if (this.decodeElementTags()) continue block15;
                        return false;
                    }
                    case 1: {
                        indexCnt = this.decodeVarint32();
                        continue block15;
                    }
                    case 12: {
                        coordCnt = this.decodeWayIndices(indexCnt);
                        continue block15;
                    }
                    case 13: {
                        if (coordCnt == 0) {
                            log.fine(this.mTile + " no coordinates");
                        }
                        this.mElem.ensurePointSize(coordCnt, false);
                        int cnt = this.decodeInterleavedPoints((GeometryBuffer)this.mElem, this.mScale);
                        if (cnt == coordCnt) continue block15;
                        log.fine(this.mTile + " wrong number of coordinates");
                        fail = true;
                        continue block15;
                    }
                    case 21: {
                        this.mElem.layer = this.decodeVarint32();
                        continue block15;
                    }
                    case 31: {
                        this.decodeVarint32();
                        continue block15;
                    }
                    case 32: {
                        this.decodeVarint32();
                        continue block15;
                    }
                    case 41: {
                        this.decodeVarint32();
                        continue block15;
                    }
                }
                log.fine(this.mTile + " invalid type for way: " + tag);
            }
            if (fail || indexCnt == 0) {
                log.fine(this.mTile + " failed reading way: bytes:" + bytes + " index:" + Arrays.toString(index) + " tag:" + (this.mElem.tags.size() > 0 ? Arrays.deepToString(this.mElem.tags.getTags()) : "null") + " " + indexCnt + " " + coordCnt);
                return false;
            }
            switch (type) {
                case 11: {
                    this.mElem.type = GeometryBuffer.GeometryType.LINE;
                    break;
                }
                case 12: {
                    this.mElem.type = GeometryBuffer.GeometryType.POLY;
                    break;
                }
                case 13: {
                    this.mElem.type = GeometryBuffer.GeometryType.POINT;
                }
            }
            this.mMapDataSink.process(this.mElem);
            return true;
        }

        private boolean decodeElementTags() throws IOException {
            int bytes = this.decodeVarint32();
            this.mElem.tags.clear();
            int cnt = 0;
            int end = this.position() + bytes;
            int max = this.mTileTags.size() - 1;
            while (this.position() < end) {
                int tagNum = this.decodeVarint32();
                if (tagNum < 0) {
                    log.fine("NULL TAG: " + this.mTile + " invalid tag:" + tagNum + " " + cnt);
                    return false;
                }
                if (tagNum < 628) {
                    this.mElem.tags.add(Tags.tags[tagNum]);
                } else {
                    if ((tagNum -= 1024) < 0 || tagNum > max) {
                        log.fine("NULL TAG: " + this.mTile + " could not find tag:" + tagNum + " " + cnt);
                        return false;
                    }
                    this.mElem.tags.add(this.mTileTags.get(tagNum));
                }
                ++cnt;
            }
            if (cnt == 0) {
                log.fine("got no TAG!");
                return false;
            }
            return true;
        }
    }
}

