/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapnik;

import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.source.ITileDecoder;
import org.oscim.tiling.source.UrlTileDataSource;
import org.oscim.tiling.source.UrlTileSource;
import org.oscim.tiling.source.mapnik.TileDecoder;

public class MapnikVectorTileSource
extends UrlTileSource {
    public MapnikVectorTileSource() {
        super("http://d1s11ojcu7opje.cloudfront.net/dev/764e0b8d", "");
        this.setUrlFormatter(new UrlTileSource.TileUrlFormatter(){

            public String formatTilePath(UrlTileSource tileSource, Tile tile) {
                byte[] hexTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
                StringBuilder sb = new StringBuilder();
                sb.append('/');
                sb.append(hexTable[tile.tileX % 16]);
                sb.append(hexTable[tile.tileY % 16]);
                sb.append('/');
                sb.append(tile.zoomLevel);
                sb.append('/');
                sb.append(tile.tileX);
                sb.append('/');
                sb.append(tile.tileY);
                return sb.toString();
            }
        });
    }

    public ITileDataSource getDataSource() {
        return new UrlTileDataSource((UrlTileSource)this, (ITileDecoder)new TileDecoder(), this.getHttpEngine());
    }
}

