/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.osmpbf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.osmosis.osmbinary.BinaryParser;
import org.openstreetmap.osmosis.osmbinary.Osmformat;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.core.osm.OsmData;
import org.oscim.core.osm.OsmNode;
import org.oscim.core.osm.OsmRelation;
import org.oscim.core.osm.OsmWay;

public class OsmPbfParser
extends BinaryParser {
    static final int NOVERSION = -1;
    static final int NOCHANGESET = -1;
    HashMap<Long, OsmNode> mNodeMap = new HashMap();
    HashMap<Long, OsmWay> mWayMap = new HashMap();

    public void complete() {
    }

    protected void parseNodes(List<Osmformat.Node> nodes) {
        for (Osmformat.Node i : nodes) {
            int tagCnt = i.getKeysCount();
            TagSet tags = new TagSet(tagCnt);
            for (int j = 0; j < tagCnt; ++j) {
                tags.add(new Tag(this.getStringById(i.getKeys(j)), this.getStringById(i.getVals(j))));
            }
            long id = i.getId();
            double latf = this.parseLat(i.getLat());
            double lonf = this.parseLon(i.getLon());
            OsmNode tmp = new OsmNode(latf, lonf, tags, id);
            this.mNodeMap.put(id, tmp);
        }
    }

    protected void parseDense(Osmformat.DenseNodes nodes) {
        long lastId = 0L;
        long lastLat = 0L;
        long lastLon = 0L;
        int j = 0;
        for (int i = 0; i < nodes.getIdCount(); ++i) {
            long id;
            long lon;
            long lat;
            TagSet tags = new TagSet(4);
            lastLat = lat = nodes.getLat(i) + lastLat;
            lastLon = lon = nodes.getLon(i) + lastLon;
            lastId = id = nodes.getId(i) + lastId;
            double latf = this.parseLat(lat);
            double lonf = this.parseLon(lon);
            if (nodes.getKeysValsCount() > 0) {
                while (nodes.getKeysVals(j) != 0) {
                    int keyid = nodes.getKeysVals(j++);
                    int valid = nodes.getKeysVals(j++);
                    tags.add(new Tag(this.getStringById(keyid), this.getStringById(valid)));
                }
                ++j;
            }
            OsmNode tmp = new OsmNode(latf, lonf, tags, id);
            this.mNodeMap.put(id, tmp);
        }
    }

    protected void parseWays(List<Osmformat.Way> ways) {
        for (Osmformat.Way i : ways) {
            int tagCnt = i.getKeysCount();
            TagSet tags = new TagSet(tagCnt);
            for (int j = 0; j < tagCnt; ++j) {
                tags.add(new Tag(this.getStringById(i.getKeys(j)), this.getStringById(i.getVals(j))));
            }
            long lastId = 0L;
            ArrayList<OsmNode> nodes = new ArrayList<OsmNode>();
            Iterator iterator = i.getRefsList().iterator();
            while (iterator.hasNext()) {
                long j = (Long)iterator.next();
                OsmNode n = this.mNodeMap.get(j + lastId);
                if (n == null) {
                    n = new OsmNode(Double.NaN, Double.NaN, null, j + lastId);
                }
                nodes.add(n);
                lastId = j + lastId;
            }
            long id = i.getId();
            OsmWay tmp = new OsmWay(tags, id, nodes);
            this.mWayMap.put(id, tmp);
        }
    }

    protected void parseRelations(List<Osmformat.Relation> rels) {
        for (Osmformat.Relation i : rels) {
            int tagCnt = i.getKeysCount();
            TagSet tags = new TagSet(tagCnt);
            for (int j = 0; j < tagCnt; ++j) {
                tags.add(new Tag(this.getStringById(i.getKeys(j)), this.getStringById(i.getVals(j))));
            }
            long id = i.getId();
            long lastMid = 0L;
            ArrayList nodes = new ArrayList();
            int memberCnt = i.getMemidsCount();
            OsmRelation osmRelation = new OsmRelation(tags, id, memberCnt);
        }
    }

    public void parse(Osmformat.HeaderBlock block) {
        for (String s : block.getRequiredFeaturesList()) {
            if (s.equals("OsmSchema-V0.6") || s.equals("DenseNodes")) continue;
            throw new RuntimeException("File requires unknown feature: " + s);
        }
    }

    public OsmData getData() {
        ArrayList<OsmWay> ways = new ArrayList<OsmWay>(this.mWayMap.values());
        ArrayList<OsmNode> nodes = new ArrayList<OsmNode>(this.mNodeMap.values());
        return new OsmData(null, nodes, ways, null);
    }
}

