/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.overpass;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.core.osm.Bound;
import org.oscim.core.osm.OsmData;
import org.oscim.core.osm.OsmElement;
import org.oscim.core.osm.OsmMember;
import org.oscim.core.osm.OsmNode;
import org.oscim.core.osm.OsmRelation;
import org.oscim.core.osm.OsmWay;

public class OverpassAPIReader {
    private static final String OVERPASS_API = "http://city.informatik.uni-bremen.de/oapi/interpreter";
    private static final int RESPONSECODE_OK = 200;
    private static final int TIMEOUT = 15000;
    private final String myBaseUrl = "http://city.informatik.uni-bremen.de/oapi/interpreter";
    private HttpURLConnection myActiveConnection;
    private InputStream responseStream;
    private final String query;
    private final List<Bound> bounds = new ArrayList<Bound>();
    private Map<Long, OsmNode> nodesById = new HashMap<Long, OsmNode>();
    private Map<Long, OsmWay> waysById = new HashMap<Long, OsmWay>();
    private Map<Long, OsmRelation> relationsById = new HashMap<Long, OsmRelation>();
    private Map<OsmRelation, List<TmpRelation>> relationMembersForRelation = new HashMap<OsmRelation, List<TmpRelation>>();
    private final Collection<OsmNode> ownNodes = new ArrayList<OsmNode>(10000);
    private final Collection<OsmWay> ownWays = new ArrayList<OsmWay>(1000);
    private final Collection<OsmRelation> ownRelations = new ArrayList<OsmRelation>(100);

    public OverpassAPIReader(double left, double right, double top, double bottom, String baseUrl, String query) {
        String bbox = "(" + Math.min(top, bottom) + "," + Math.min(left, right) + "," + Math.max(top, bottom) + "," + Math.max(left, right) + ")";
        this.query = query.replaceAll("\\{\\{bbox\\}\\}", bbox);
    }

    private InputStream getInputStream(String pUrlStr) throws IOException {
        URL url = new URL(pUrlStr);
        this.myActiveConnection = (HttpURLConnection)url.openConnection();
        this.myActiveConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        int responseCode = this.myActiveConnection.getResponseCode();
        if (responseCode != 200) {
            String apiErrorMessage = this.myActiveConnection.getHeaderField("Error");
            String message = apiErrorMessage != null ? "Received API HTTP response code " + responseCode + " with message \"" + apiErrorMessage + "\" for URL \"" + pUrlStr + "\"." : "Received API HTTP response code " + responseCode + " for URL \"" + pUrlStr + "\".";
            throw new IOException(message);
        }
        this.myActiveConnection.setConnectTimeout(15000);
        String encoding = this.myActiveConnection.getContentEncoding();
        this.responseStream = this.myActiveConnection.getInputStream();
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            this.responseStream = new GZIPInputStream(this.responseStream);
        } else if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
            this.responseStream = new InflaterInputStream(this.responseStream, new Inflater(true));
        }
        return this.responseStream;
    }

    public void parse(InputStream in) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        try {
            JsonToken t;
            JsonParser jp = jsonFactory.createParser(in);
            while ((t = jp.nextToken()) != null) {
                if (t != JsonToken.START_OBJECT) continue;
                jp.nextToken();
                String name = jp.getCurrentName();
                jp.nextToken();
                if (!"type".equals(name)) continue;
                String type = jp.getText();
                if ("node".equals(type)) {
                    this.parseNode(jp);
                    continue;
                }
                if ("way".equals(type)) {
                    this.parseWay(jp);
                    continue;
                }
                if (!"relation".equals(type)) continue;
                this.parseRelation(jp);
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
    }

    private void parseNode(JsonParser jp) throws JsonParseException, IOException {
        long id = 0L;
        double lat = 0.0;
        double lon = 0.0;
        TagSet tags = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            jp.nextToken();
            if ("id".equals(name)) {
                id = jp.getLongValue();
                continue;
            }
            if ("lat".equals(name)) {
                lat = jp.getDoubleValue();
                continue;
            }
            if ("lon".equals(name)) {
                lon = jp.getDoubleValue();
                continue;
            }
            if (!"tags".equals(name)) continue;
            tags = OverpassAPIReader.parseTags(jp);
        }
        OsmNode node = new OsmNode(lat, lon, tags, id);
        this.ownNodes.add(node);
        this.nodesById.put(id, node);
    }

    private void parseWay(JsonParser jp) throws JsonParseException, IOException {
        long id = 0L;
        TagSet tags = null;
        ArrayList<OsmNode> wayNodes = new ArrayList<OsmNode>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            jp.nextToken();
            if ("id".equals(name)) {
                id = jp.getLongValue();
                continue;
            }
            if ("nodes".equals(name)) {
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    Long nodeId = jp.getLongValue();
                    OsmNode node = this.nodesById.get(nodeId);
                    if (node == null) continue;
                    wayNodes.add(node);
                }
                continue;
            }
            if (!"tags".equals(name)) continue;
            tags = OverpassAPIReader.parseTags(jp);
        }
        OsmWay way = new OsmWay(tags, id, wayNodes);
        this.ownWays.add(way);
        this.waysById.put(id, way);
    }

    private void parseRelation(JsonParser jp) throws JsonParseException, IOException {
        long id = 0L;
        TagSet tags = null;
        ArrayList<TmpRelation> members = new ArrayList<TmpRelation>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            jp.nextToken();
            if ("id".equals(name)) {
                id = jp.getLongValue();
                continue;
            }
            if ("members".equals(name)) {
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    TmpRelation member = new TmpRelation();
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        name = jp.getCurrentName();
                        jp.nextToken();
                        if ("type".equals(name)) {
                            member.type = jp.getText();
                            continue;
                        }
                        if ("ref".equals(name)) {
                            member.id = jp.getLongValue();
                            continue;
                        }
                        if (!"role".equals(name)) continue;
                        member.role = jp.getText();
                    }
                    members.add(member);
                }
                continue;
            }
            if (!"tags".equals(name)) continue;
            tags = OverpassAPIReader.parseTags(jp);
        }
        OsmRelation relation = new OsmRelation(tags, id, members.size());
        this.ownRelations.add(relation);
        this.relationsById.put(id, relation);
        this.relationMembersForRelation.put(relation, members);
    }

    private static TagSet parseTags(JsonParser jp) throws JsonParseException, IOException {
        TagSet tags = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            jp.nextToken();
            String val = jp.getText();
            if (tags == null) {
                tags = new TagSet(4);
            }
            tags.add(new Tag(key, val, false));
        }
        return tags;
    }

    private static void log(String msg) {
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsmData getData() {
        String encoded;
        try {
            encoded = URLEncoder.encode(this.query, "utf-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
            return null;
        }
        System.out.println("http://city.informatik.uni-bremen.de/oapi/interpreter?data=" + encoded);
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream("http://city.informatik.uni-bremen.de/oapi/interpreter?data=[out:json];" + encoded);
            this.parse(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            inputStream = null;
        }
        for (Map.Entry<OsmRelation, List<TmpRelation>> entry : this.relationMembersForRelation.entrySet()) {
            OsmRelation relation = entry.getKey();
            for (TmpRelation member : entry.getValue()) {
                OsmElement memberObject = null;
                if ("node".equals(member)) {
                    memberObject = this.nodesById.get(member.id);
                } else if ("way".equals(member)) {
                    memberObject = this.waysById.get(member.id);
                } else {
                    if (!"relation".equals(member)) continue;
                    memberObject = this.relationsById.get(member.id);
                }
                if (memberObject == null) continue;
                OsmMember ownMember = new OsmMember(member.role, memberObject);
                relation.relationMembers.add(ownMember);
            }
        }
        OverpassAPIReader.log("nodes: " + this.ownNodes.size() + " ways: " + this.ownWays.size() + " relations: " + this.ownRelations.size());
        this.nodesById = null;
        this.waysById = null;
        this.relationsById = null;
        this.relationMembersForRelation = null;
        return new OsmData(this.bounds, this.ownNodes, this.ownWays, this.ownRelations);
    }

    class TmpRelation {
        Long id;
        String type;
        String role;

        TmpRelation() {
        }
    }
}

